% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covjmcm_mcd.R
\name{covjmcm_mcd}
\alias{covjmcm_mcd}
\title{Calculate the estimation of the covariance of estimated parameters in a MCD model, via the explicit formula.}
\usage{
covjmcm_mcd(object)
}
\arguments{
\item{object}{a fitted joint mean-covariance model of class "jmcmMod", returned by the function \code{jmcm}.}
}
\value{
an estimated covariance matrix of the estimated parameters in a MCD model.
}
\description{
\code{covjmcm_mcd} gives an estimation of the covariance of estimated parameters in a MCD model using
the explicit formula, which is the inverse of the estimated Fisher's information matrix.
}
\examples{
cattleA <- cattle[cattle$group=='A', ]
fit.mcd <- jmcm(weight|id|I(ceiling(day/14+1))~1|1,
               data = cattleA, cov.method = "mcd",
               triple = c(8,3,4))
cov.mcd <- covjmcm_mcd(fit.mcd)
}
\references{
[1] Pourahmadi, M., "Maximum likelihood estimation of generalised linear models for multivariate normal covariance matrix," Biometrika
87(2), 425–435 (2000).
}
\seealso{
\code{\link{covjmcm}}, \code{\link{covjmcm_acd}}, and \code{\link{covjmcm_hpc}}
}
