% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootcovjmcm.R
\name{bootcovjmcm}
\alias{bootcovjmcm}
\title{Estimate the covariance of estimated parameters using a bootstrap based method}
\usage{
bootcovjmcm(object, mydata, numboot)
}
\arguments{
\item{object}{a fitted joint mean-covariance model of class "jmcmMod", returned by the function \code{jmcm}.}

\item{mydata}{the data frame used in fitting the model.}

\item{numboot}{the number of the bootstrap replications}
}
\value{
an estimated covariance matrix of the estimated parameters.
}
\description{
\code{bootcovjmcm} gives the estimation of the covariance of estimated parameters returned by \code{jmcm} by using a bootstrap based method.
}
\examples{
cattleA <- cattle[cattle$group=='A', ]
fit.mcd <- jmcm(weight|id|I(ceiling(day/14+1))~1|1,
               data = cattleA,
               cov.method = "mcd",
               triple = c(1,1,1))
bootcovjmcm(fit.mcd, cattleA, 5)
## Larger number of replications is needed to achieve accuracy,
## however it may take hours.
\donttest{bootcovjmcm(fit.mcd, cattleA, 500)}
}
\references{
[1] Liu, R.Y. (1988) "Bootstrap Procedure under Some Non-i.i.d. Models." Annals of Statistics, 16, 1696-1708.
}
