% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pick.4.1xday}
\alias{pick.4.1xday}
\title{Pick 4 (once daily)}
\format{A data frame with 1,041 rows and 5 variables:
\describe{
  \item{date}{date of draw}
  \item{N1}{1st digit}
  \item{N2}{2nd digit}
  \item{N3}{3rd digit}
  \item{N4}{4th digit}
}}
\source{
\url{https://www.valottery.com}
}
\usage{
pick.4.1xday
}
\description{
Historical data for the Pick 4 once daily game. Game play: Pick
a four digit number from 0000 through 9999. Note: On January 30, 1995,
Pick 4 switched to twice daily drawings.
}
\examples{
## Any Pick 4 happen more than once?
results <- apply(pick.4.1xday[,-1],1,function(x)paste(x,collapse = ""))
any(table(results) > 1)
## Which numbers?
i <- which(table(results) > 1,useNames = FALSE)
sort(table(results)[i],decreasing = TRUE)
}
\keyword{datasets}

