% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confrontation.R
\name{confront}
\alias{confront}
\alias{confront,data.frame,indicator,ANY-method}
\alias{confront,data.frame,indicator,environment-method}
\alias{confront,data.frame,indicator,data.frame-method}
\alias{confront,data.frame,indicator,list-method}
\alias{confront,data.frame,validator,ANY-method}
\alias{confront,data.frame,validator,environment-method}
\alias{confront,data.frame,validator,data.frame-method}
\alias{confront,data.frame,validator,list-method}
\title{Confront data with a (set of) expressionset(s)}
\usage{
confront(dat, x, ref, ...)

\S4method{confront}{data.frame,indicator,ANY}(dat, x, key = NULL, ...)

\S4method{confront}{data.frame,indicator,environment}(dat, x, ref, key = NULL, ...)

\S4method{confront}{data.frame,indicator,data.frame}(dat, x, ref, key = NULL, ...)

\S4method{confront}{data.frame,indicator,list}(dat, x, ref, key = NULL, ...)

\S4method{confront}{data.frame,validator,ANY}(dat, x, key = NULL, ...)

\S4method{confront}{data.frame,validator,environment}(dat, x, ref, key = NULL, ...)

\S4method{confront}{data.frame,validator,data.frame}(dat, x, ref, key = NULL, ...)

\S4method{confront}{data.frame,validator,list}(dat, x, ref, key = NULL, ...)
}
\arguments{
\item{dat}{An R object carrying data}

\item{x}{An R object carrying \code{\link{rule}}s.}

\item{ref}{Optionally, an R object carrying reference data. See examples for usage.}

\item{...}{Options used at execution time (especially \code{'raise'}). 
See \code{\link{voptions}}.}

\item{key}{(optional) name of identifying variable in x.}
}
\description{
An expressionset is a general class storing rich expressions (basically
expressions and some meta data) which we call 'rules'. Examples of
expressionset implementations are \code{\link{validator}} objects, storing
validation rules and \code{\link{indicator}} objects, storing data quality
indicators. The \code{confront} function evaluates the expressions one by one
on a dataset while recording some process meta data. All results are stored in
a (subclass of a) \code{confrontation} object.
}
\section{Reference data}{


Reference data is typically a \code{list} with a items such as
a code list, or a data frame of which rows match the rows of the
data under scrutiny.
}

\examples{

# a basic validation example
v <- validator(height/weight < 0.5, mean(height) >= 0)
cf <- confront(women, v)
summary(cf)
plot(cf)
as.data.frame(cf)

# an example checking metadata
v <- validator(nrow(.) == 15, ncol(.) > 2)
summary(confront(women, v))

# An example using reference data
v <- validator(weight == ref$weight)
summary(confront(women, v, women))

# Usging custom names for reference data
v <- validator(weight == test$weight)
summary( confront(women,v, list(test=women)) )

# Reference data in an environment
e <- new.env()
e$test <- women
v <- validator(weight == test$weight)
summary( confront(women, v, e) )

# the effect of using a key
w <- women
w$id <- letters[1:nrow(w)]
v <- validator(weight == ref$weight)

# with complete data; already matching
values( confront(w, v, w, key='id'))

# with scrambled rows in reference data (reference gets sorted according to dat)
i <- sample(nrow(w))
values(confront(w, v, w[i,],key='id'))

# with incomplete reference data
values(confront(w, v, w[1:10,],key='id'))


}
\seealso{
\code{\link{voptions}}

Other confrontation-methods: 
\code{\link{[,expressionset-method}},
\code{\link{as.data.frame,confrontation-method}},
\code{\link{confrontation-class}},
\code{\link{errors}()},
\code{\link{event}()},
\code{\link{keyset}()},
\code{\link{length,expressionset-method}},
\code{\link{values}()}

Other validation-methods: 
\code{\link{aggregate,validation-method}},
\code{\link{all,validation-method}},
\code{\link{any,validation-method}},
\code{\link{barplot,validation-method}},
\code{\link{check_that}()},
\code{\link{compare}()},
\code{\link{event}()},
\code{\link{names<-,rule,character-method}},
\code{\link{plot,validation-method}},
\code{\link{sort,validation-method}},
\code{\link{summary}()},
\code{\link{validation-class}},
\code{\link{values}()}

Other indication-methods: 
\code{\link{event}()},
\code{\link{indication-class}},
\code{\link{summary}()}
}
\concept{confrontation-methods}
\concept{indication-methods}
\concept{validation-methods}
