% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funop.R
\name{funop}
\alias{funop}
\title{Identifies outliers in a numeric vector}
\usage{
funop(x, A = 0, B = 1.5)
}
\arguments{
\item{x}{Numeric vector to inspect for outliers (does not need to be ordered)}

\item{A}{Number of standard deviations beyond the median of \code{x}}

\item{B}{Multiples beyond the median slope of candidate values}
}
\value{
A data frame containing one row for every member of \code{x} (in the same
order as \code{x}) and the
following columns:
\itemize{
\item \code{y}: Original values of vector \code{x}
\item \code{i}: Ordinal position of value \code{y} in the sorted vector \code{x}
\item \code{middle}: Boolean indicating whether ordinal position \code{i} is in the middle third of the vector
\item \code{a}: Result of \code{a_qnorm(i, length(x))}
\item \code{z}: Slope of \code{y} relative to \code{median(y)}
\item \code{special}: Boolean indicating whether \code{y} is an outlier
}
}
\description{
FUNOP stands for FUll NOrmal Plot.

The procedure identifies outliers by calculating their slope (\code{z}),
relative to the vector's median.

The procedure ignores values in the middle third of the \emph{ordered}
vector. The remaining values are all candidates for consideration. The
slopes of all candidates are calculated, and the median of their slopes
is used as the primary basis for identifying outliers.

Any value whose slope is \code{B} times larger than the median slope is
identified as an outlier. Additionally, any value whose \emph{magnitude}
is larger than that of the slope-based outliers is also identified as
an outlier.

However, the procedure will \emph{not} identify as outliers any values
within \code{A} standard deviations of the vector's median (i.e., not
the median of candidate slopes).
}
\examples{
funop(c(1, 2, 3, 11))
funop(table_1)

attr(funop(table_1), 'z_split')
}
\references{
Tukey, John W. "The Future of Data Analysis."
\emph{The Annals of Mathematical Statistics},
\emph{33}(1), 1962, pp 1-67. \emph{JSTOR},
\url{https://www.jstor.org/stable/2237638}.
}
\seealso{
\code{\link[=a_qnorm]{a_qnorm()}}
}
