% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_event.R
\name{benchmark_event}
\alias{benchmark_event}
\title{Compare Probability of an Event with Benchmark}
\usage{
benchmark_event(
  data,
  column,
  benchmark,
  event,
  count,
  total,
  event_type = "",
  remove_missing = TRUE,
  notes = "minimal",
  input = "long",
  output = "console"
)
}
\arguments{
\item{data}{dataset}

\item{column}{name of column}

\item{benchmark}{benchmark}

\item{event}{specify event as given in column (example: 0, "pass", "success")}

\item{count}{number of times event has occurred. Use only when using input = "values"}

\item{total}{total number of all events. Use only when using input = "values"}

\item{event_type}{Optional: a string describing the type of event. For example, success, failure, etc.}

\item{remove_missing}{TRUE/FALSE (Default is TRUE)}

\item{notes}{whether output should contain minimal or technical type of notes. Defaults to "minimal". Use "none" to turn off.}

\item{input}{Default: "long" - long form of data, "values" to pass values directly. If using this option, must specify count and total.}

\item{output}{Default: "console" - prints output in console and returns tibble invisibly.}
}
\value{
Dataframe of results when saved to an object. Show console output by default
}
\description{
Compare Probability of an Event with Benchmark
}
\examples{
data <- data.frame(task_1 = c("y", "y", "y", "y", "n", "n", "n", NA, NA, NA, NA, NA, NA, NA),
                   task_2 = c(0, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1))
# With dataframe columns

benchmark_event(data, column = task_1, benchmark = 0.8, event = "y")
benchmark_event(data, column = task_2, benchmark = 0.3, event = 1, event_type = "success")

# Also pipeable
data |>
  benchmark_event(column = task_2, benchmark = 0.3, event = 1, event_type = "success")

# With direct values
benchmark_event(benchmark = 0.8, count = 4, total = 7, input = "values")
}
