% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ustfd_query.R
\name{filter-syntax}
\alias{filter-syntax}
\title{Request filtered API results}
\description{
Fiscal Data API allows for the filtering of results on the server side,
leading to a smaller payload. The combinations of fields and operators
supported are not currently defined, so it is suggested you test the desired
combinations before relying on them.
}
\section{Syntax}{

A filter should be a named list of key-value pairs where the name corresponds
to the field that should be filtered and the value is a character vector or a
list where the name of an item corresponds to the operator and the value
corresponds to the operand. One field may have more than one filter.
}

\section{Operators}{

\itemize{
\item \code{>}, \code{<}  Greater-than and lesser-than
\item \code{>=}, \code{<=}  Greater-/lesser-than or equal-to
\item \code{=}  Equal to
\item \verb{in}  Subset-of
}
}

\examples{
\dontrun{
 #records with a record_date no older than 10 days ago
 list(record_date = c('>=' = lubridate::today()-10))

 #records with a record_date between two dates
 list(
   record_date = c('>=' = '2022-01-01'),
   record_date = c('<=' = '2022-12-31')
 )

 #records with a specific record_date
 list(record_date = c('=' = lubridate::today()-2))

 #records where record_date is any of a set of specific dates
 list(
   record_date = list('in' = c('2022-06-13','2022-06-15','2022-06-17')
 )
}

}
