% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ColumnReorder.r
\name{moveToFront}
\alias{moveToFront}
\alias{moveToBack}
\title{moveToFront}
\usage{
moveToFront(data, cols)

moveToBack(data, cols)
}
\arguments{
\item{data}{data.frame}

\item{cols}{Character vector specifying the columns to be moved to the front or back}
}
\value{
A data.frame with the columns in the right order
}
\description{
Rearranges column order by moving specified columns to the front or back.
}
\details{
Rearranges column order by moving specified columns to the front or back.
}
\examples{
theDF <- data.frame(A=1:10, B=11:20, C=1:10, D=11:20)
moveToFront(theDF, c('B', 'C'))
moveToFront(theDF, c('C', 'B'))
moveToFront(theDF, c('C', 'C'))
moveToBack(theDF, c('C', 'C'))
moveToBack(theDF, c('C', 'B'))
moveToBack(theDF, c('C', 'C'))

}
\author{
Jared P. Lander
}
