% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{dist_groups}
\alias{dist_groups}
\title{Create a data frame of distances between groups of items.}
\usage{
dist_groups(d, g)
}
\arguments{
\item{d}{A distance matrix object of class \code{dist}.}

\item{g}{A factor representing the groups of objects in \code{d}.}
}
\value{
A data frame with 6 columns:
\describe{
  \item{Item1, Item2}{The items being compared.}
  \item{Group1, Group2}{The groups to which the items belong.}
  \item{Label}{A convenient label for plotting or comparison.}
  \item{Distance}{The distance between Item1 and Item2.}}
}
\description{
Create a data frame of distances between groups of items.
}
\examples{
m4 <- matrix(1:16, nrow=4, dimnames=list(LETTERS[1:4]))
dm4 <- dist(m4)
g4 <- rep(c("Control", "Treatment"), each=2)
dist_groups(dm4, g4)
}
