% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doj_blog_entries.R
\name{doj_blog_entries}
\alias{doj_blog_entries}
\title{Retrieve DOJ Blog Entries}
\usage{
doj_blog_entries(
  n_results = 50,
  search_direction = "DESC",
  keyword = NULL,
  clean = TRUE
)
}
\arguments{
\item{n_results}{Integer. Number of blog entries to retrieve. Default is 50.}

\item{search_direction}{Character. Sort order: either "ASC" (oldest first) or "DESC" (newest first). Default is "DESC".}

\item{keyword}{Optional character string to filter results by keyword.}

\item{clean}{Logical. If TRUE, cleans up the blog body and teaser fields. Default is TRUE.}
}
\value{
A cleaned dataframe containing DOJ blog entry metadata and content.
}
\description{
This function retrieves blog entries from the U.S. Department of Justice API.
You can specify the number of results, sort direction, and an optional keyword filter.
}
\examples{
\dontrun{
# Retrieve a single DOJ blog entry
result <- doj_blog_entries(n_results = 1)
print(result)
}

}
