% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{sp500_tbl_df}
\alias{sp500_tbl_df}
\title{Financial information for 50 S&P 500 companies}
\format{
A tibble with 50 observations and 12 variables:
\describe{
  \item{stock}{Factor indicating the stock ticker symbol of the company.}
  \item{market_cap}{Numeric representing the market capitalization of the company.}
  \item{ent_value}{Numeric representing the enterprise value of the company.}
  \item{trail_pe}{Numeric representing the trailing price-to-earnings ratio.}
  \item{forward_pe}{Numeric representing the forward price-to-earnings ratio.}
  \item{ev_over_rev}{Numeric representing the enterprise value to revenue ratio.}
  \item{profit_margin}{Numeric representing the profit margin of the company.}
  \item{revenue}{Numeric representing the total revenue generated by the company.}
  \item{growth}{Numeric representing the growth rate of the company.}
  \item{earn_before}{Numeric representing the earnings before interest and taxes (EBIT).}
  \item{cash}{Numeric representing the cash holdings of the company.}
  \item{debt}{Numeric representing the total debt of the company.}
}
}
\source{
Data on S&P 500 companies, including financial metrics and ratios.
}
\usage{
data(sp500_tbl_df)
}
\description{
The dataset name has been changed to 'sp500_tbl_df' to avoid confusion with other packages
in the R ecosystem. This naming convention helps distinguish this dataset as part of the 'usdatasets'
package and identifies it as a tibble. The original content of the dataset has not been modified.
}
