% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{census_tbl_df}
\alias{census_tbl_df}
\title{Random sample of 2000 U.S. Census Data}
\format{
A tibble with 500 observations and 8 variables:
\describe{
  \item{census_year}{Year of the census (in integer).}
  \item{state_fips_code}{FIPS code for the state (factor with 47 levels).}
  \item{total_family_income}{Total family income (in US dollars).}
  \item{age}{Age of the individual (in years).}
  \item{sex}{Sex of the individual (factor: male/female).}
  \item{race_general}{General race category (factor with 8 levels).}
  \item{marital_status}{Marital status of the individual (factor with 6 levels).}
  \item{total_personal_income}{Total personal income (in US dollars).}
}
}
\source{
US Census Bureau
}
\usage{
data(census_tbl_df)
}
\description{
The dataset name has been changed to 'census_tbl_df' to avoid confusion with other packages
in the R ecosystem from which datasets have been sourced. This naming convention helps
distinguish this dataset as part of the 'usdatasets' package and assists users in identifying
its specific characteristics. The suffix 'tbl_df' identifies the dataset as a tibble. The original content of the dataset has not been modified in any way.
}
