% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/uptimerobot.account.details.R
\name{uptimerobot.account.details}
\alias{uptimerobot.account.details}
\title{Get the account details for who is linked to the given API key}
\usage{
uptimerobot.account.details(api.key, unlist = FALSE)
}
\arguments{
\item{api.key}{string with a valid key for connecting to Uptimerobot API.}

\item{unlist}{logical. Set to \code{TRUE} to unlist the output to a named vector, \code{FALSE} to get a named list.}
}
\value{
A list or a vector with the account details.
}
\description{
\code{uptimerobot.account.details} returns a list or a vector with the account details connected to the given api key.
}
\examples{
\dontrun{
# Let's assume the api.key is available into the environment variable KEY
api.key <- Sys.getenv("KEY", "")

# Returns details as a list
details.list <- uptimerobot.account.details(api.key)

# Returns details as a vector
details.num <- uptimerobot.account.details(api.key, unlist = TRUE)
}
}
\author{
Gabriele Baldassarre
}

