% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlpois.R
\name{mlpois}
\alias{mlpois}
\title{Poisson distribution maximum likelihood estimation}
\usage{
mlpois(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{currently affects nothing.}
}
\value{
\code{mlpois} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
\code{lambda} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
The maximum likelihood estimate of \code{lambda} is the empirical mean.
}
\details{
For the density function of the Poisson distribution see
\link[stats:Poisson]{Poisson}.
}
\examples{
mlpois(ChickWeight$weight)
}
\references{
Johnson, N. L., Kemp, A. W., & Kotz, S. (2005). Univariate Discrete Distributions (3rd ed.). Wiley-Blackwell.
}
\seealso{
\link[stats:Poisson]{Poisson} for the Poisson density.
}
