% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting-unitquantreg.R
\name{unitquantreg}
\alias{unitquantreg}
\alias{unitquantreg.fit}
\title{Parametric unit quantile regression models}
\usage{
unitquantreg(
  formula,
  data,
  subset,
  na.action,
  tau,
  family,
  link = c("logit", "probit", "cloglog", "cauchit"),
  link.theta = c("identity", "log", "sqrt"),
  start = NULL,
  control = unitquantreg.control(),
  model = TRUE,
  x = FALSE,
  y = TRUE
)

unitquantreg.fit(
  y,
  X,
  Z = NULL,
  tau,
  family,
  link,
  link.theta,
  start = NULL,
  control = unitquantreg.control()
)
}
\arguments{
\item{formula}{symbolic description of the quantile model like \code{y ~ x}
or \code{y ~ x | z}. See below for details.}

\item{data}{data.frame contain the variables in the model.}

\item{subset}{an optional vector specifying a subset of observations to
be used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the
data contain \code{NA}s.}

\item{tau}{numeric vector. The quantile(s) to be estimated, i.e.,
number between 0 and 1. If just one quantile is specified an object of class
\code{unitquantreg} is returned. If a numeric vector of values between 0 and 1
is specified an object of class \code{unitquantregs} is returned. See below for
details.}

\item{family}{character. Specify the distribution family.}

\item{link}{character. Specify the link function in the quantile model.
Currently supported are \code{logit}, \code{probit}, \code{cloglog} and
\code{cauchit}. Default is \code{logit}.}

\item{link.theta}{character. Specify the link function in the shape model.
Currently supported are \code{identity}, \code{log} and \code{sqrt}.
Default is \code{log}.}

\item{start}{numeric vector. An optional vector with starting values for all parameters.}

\item{control}{list. Control arguments specified via \code{\link{unitquantreg.control}}.}

\item{model}{logical. Indicates whether model frame should be included as a
component of the returned value.}

\item{x, y}{logical. If \code{TRUE} the corresponding components of the fit
(model frame, response, model matrix) are returned. For \code{\link{unitquantreg.fit}}
\code{y} should be the numeric response vector with values in (0,1).}

\item{X, Z}{numeric matrix. Regressor matrix for the quantile and shape model,
respectively. Default is constant shape model, i.e., \code{Z} is matrix with
column of ones.}
}
\value{
\code{\link{unitquantreg}} can return an object of
class \code{unitquantreg} if \code{tau} is a scalar, i.e., a list with
the following components.
\item{family}{the distribution family name.}
\item{coefficients}{a list with elements \code{"quantile"} and \code{"shape"}
containing the coefficients from the respective models.}
\item{fitted.values}{a list with elements \code{"quantile"} and \code{"shape"}
containing the fitted parameters from the respective models.}
\item{linear.predictors}{a list with elements \code{"quantile"} and \code{"shape"}
containing the fitted linear predictors from the respective models.}
\item{link}{a list with elements \code{"quantile"} and \code{"shape"}
containing the link objects from the respective models.}
\item{tau}{the quantile specify.}
\item{loglik}{log-likelihood of the fitted model.}
\item{gradient}{gradient evaluate at maximum likelihood estimates.}
\item{vcov}{covariance matrix of all parameters in the model.}
\item{nobs}{number of observations.}
\item{npar}{number of parameters.}
\item{df.residual}{residual degrees of freedom in the fitted model.}
\item{theta_const}{logical indicating if the \eqn{\theta} parameter was treated as nuisance parameter.}
\item{control}{the control parameters used to fit the model.}
\item{iterations}{number of iterations of optimization method.}
\item{converged}{logical, if \code{TRUE} indicates successful convergence.}
\item{kkt}{a list of logical  \code{kkt1} and \code{kkt2} provide check on
Kuhn-Karush-Tucker conditions, first-order KKT test (\code{kkt1}) checks
whether the gradient at the final parameters estimates is "small" and the
second-order KKT test (\code{kkte}) checks whether the Hessian at the final
parameters estimates is positive definite.}
\item{elapsed_time}{time elapsed to fit the model.}
\item{call}{the original function call.}
\item{formula}{the original model formula.}
\item{terms}{a list with elements \code{"quantile"}, \code{"shape"} and
\code{"full"} containing the \code{terms} objects for the respective models.}
\item{model}{the full model frame, if \code{model = TRUE}.}
\item{y}{the response vector, if \code{y = TRUE}.}
\item{x}{a list with elements \code{"quantile"} and \code{"shape"}
containing the model matrices from the respective models, if \code{x = TRUE}.}

While \code{\link{unitquantreg.fit}} returns an unclassed list with
components up to \code{elapsed_time}.

If \code{tau} is a numeric vector with length greater than one an object of
class \code{unitquantregs} is returned, which consist of list of objects of
class \code{unitquantreg} for each specified quantiles.
}
\description{
Fit a collection of parametric unit quantile regression model
by maximum likelihood using the log-likelihood function, the score vector
and the hessian matrix implemented in \code{C++}.
}
\details{
The parameter estimation and inference are performed under the frequentist paradigm.
The \code{\link[optimx]{optimx}} R package is use, since allows different optimization
technique to maximize the log-likelihood function.  The analytical score function are
use in the maximization and the standard errors are computed using the
analytical hessian matrix, both are implemented in efficient away using \code{C++}.
}
\author{
André F. B. Menezes
}
