% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_def_1.R
\docType{data}
\name{pal_grau}
\alias{pal_grau}
\title{uni.kn color palette grau}
\format{
An object of class \code{data.frame} with 1 rows and 5 columns.
}
\usage{
pal_grau
}
\description{
\code{pal_grau} provides an additional uni.kn color palette  
as a data frame containing 5 colors (shades of 
\code{\link{Grau}} or grey).
}
\details{
See \url{https://www.uni-konstanz.de/en/university/news-and-media/create-online-and-print-media/corporate-design/} for details.
}
\examples{
pal_grau
dim(pal_grau)  # 1 5
pal_grau[3]    # preferred (named) color "grau3"
pal_grau[[3]]  # preferred color "grau3" OR "#9AA0A7"

# Plotting palette:
seecol(pal_grau)

}
\seealso{
\code{\link{pal_unikn}} for the unikn default color palette with all 5 colors of \code{\link{pal_seeblau}}; 
\code{\link{pal_unikn_pref}} for a uni.kn color palette with all preferred colors; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes.

Other color palettes: 
\code{\link{pal_bordeaux}},
\code{\link{pal_karpfenblau}},
\code{\link{pal_peach}},
\code{\link{pal_petrol}},
\code{\link{pal_pinky}},
\code{\link{pal_seeblau}},
\code{\link{pal_seegruen}},
\code{\link{pal_signal}},
\code{\link{pal_unikn}},
\code{\link{pal_unikn_dark}},
\code{\link{pal_unikn_light}},
\code{\link{pal_unikn_pair}},
\code{\link{pal_unikn_ppt}},
\code{\link{pal_unikn_pref}},
\code{\link{pal_unikn_web}}
}
\concept{color palettes}
\keyword{datasets}
