% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipsoid.R
\name{runif_ellipsoid}
\alias{runif_ellipsoid}
\alias{runif_on_ellipse}
\alias{runif_on_ellipsoid}
\alias{runif_in_ellipsoid}
\title{Uniform sampling on/in ellipsoid}
\usage{
runif_on_ellipse(n, A, r)

runif_on_ellipsoid(n, A, r)

runif_in_ellipsoid(n, A, r)
}
\arguments{
\item{n}{number of simulations}

\item{A}{symmetric positive-definite matrix defining the ellipsoid (see
Details), of size 2 for \code{runif_on_ellipse} and size 2 or 3 for 
\code{runif_on_ellipsoid} (for size 2 these are the same functions)}

\item{r}{"radius" (see Details)}
}
\value{
The simulations in a matrix with \code{n} rows.
}
\description{
Uniform sampling on an ellipsoid or in an ellipsoid. 
  The sampling \emph{in} an ellipsoid is available in arbitrary
  dimension. The sampling \emph{on} an ellipsoid is available only in 
  dimension 2 or 3.
}
\details{
The ellipsoid is the set of vectors \code{x} satisfying
  \code{t(x) \%*\% A \%*\% x == r^2}. For example, for an axis-aligned 
  ellipse with horizontal radius \code{a} and vertical radius \code{b}, take 
  \code{A=1/diag(c(a^2,b^2))} and \code{r=1}.
}
\examples{
library(uniformly)
set.seed(666L)
# ellipse parameters
A <- rbind(c(2, 1), c(1, 1))
r <- 2
# plot the ellipse
x1 <- seq(-2.5, 2.5, length.out = 100)
x2 <- seq(-3, 3, length.out = 100)
z <- outer(
  x1, x2, FUN = Vectorize(function(x1, x2) t(c(x1, x2)) \%*\% A \%*\% c(x1, x2))
)
contour(x1, x2, z, nlevels = 1, levels = r^2, asp = 1, drawlabels = FALSE)
# simulations on the perimeter
sims <- runif_on_ellipse(60, A, r)
points(sims, pch = 19, col = "blue")
# simulations in the area
sims <- runif_in_ellipsoid(100, A, r)
points(sims, pch = 19, col = "green")
\donttest{# 3D example ####
A <- matrix(c(5,1,1, 1,3,1, 1,1,1), ncol = 3L)
r <- 2
# draw the ellipsoid
library(misc3d)
x <- seq(-1, 1, length.out = 50)
y <- seq(-1.5, 1.5, length.out = 50)
z <- seq(-2.7, 2.7, length.out = 50)
g <- as.matrix(expand.grid(x = x, y = y, z = z))
voxel <- 
  array(apply(g, 1L, function(v) t(v) \%*\% A \%*\% v), dim = c(50, 50, 50))
isosurface <- computeContour3d(voxel, max(voxel), r^2, x = x, y = y, z = z)
drawScene.rgl(makeTriangles(isosurface, alpha = 0.3))
# simulate and plot points on ellipsoid
library(rgl)
sims <- runif_on_ellipsoid(300, A, r)
points3d(sims)}
}
