% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{cross_val_score}
\alias{cross_val_score}
\title{Cross-Validation for Model Objects}
\usage{
cross_val_score(
  model,
  X,
  y,
  cv = 5,
  scoring = NULL,
  show_progress = TRUE,
  cl = NULL,
  ...
)
}
\arguments{
\item{model}{A Model object}

\item{X}{Feature matrix or data.frame}

\item{y}{Target vector (type determines regression vs classification)}

\item{cv}{Number of cross-validation folds (default: 5)}

\item{scoring}{Scoring metric: "rmse", "mae", "accuracy", or "f1"
(default: auto-detected based on task)}

\item{show_progress}{Whether to show progress bar (default: TRUE)}

\item{cl}{Optional cluster for parallel processing (not yet implemented)}

\item{...}{Additional arguments passed to model$fit()}
}
\value{
Vector of cross-validation scores for each fold
}
\description{
Perform k-fold cross-validation with consistent scoring metrics
across different model types. The scoring metric is automatically
selected based on the detected task type.
}
\examples{
\donttest{
library(glmnet)
X <- matrix(rnorm(100), ncol = 4)
y <- 2*X[,1] - 1.5*X[,2] + rnorm(25)  # numeric -> regression

mod <- Model$new(glmnet::glmnet)
mod$fit(X, y, alpha = 0, lambda = 0.1)
cv_scores <- cross_val_score(mod, X, y, cv = 5)  # auto-uses RMSE
mean(cv_scores)  # Average RMSE

# Classification with accuracy scoring
data(iris)
X_class <- as.matrix(iris[, 1:4])
y_class <- iris$Species  # factor -> classification

mod2 <- Model$new(e1071::svm)
cv_scores2 <- cross_val_score(mod2, X_class, y_class, cv = 5)  # auto-uses accuracy
mean(cv_scores2)  # Average accuracy
}

}
