% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unglue_sub.R
\name{unglue_sub}
\alias{unglue_sub}
\title{unglue_sub}
\usage{
unglue_sub(x, patterns, repl, open = "{", close = "}")
}
\arguments{
\item{x}{character vector}

\item{patterns}{a character vector or a list of character vectors, if a list,
items will be pasted using an empty separator (\code{""}).}

\item{repl}{function to apply on matched substrings, formula (if package rlang
is installed), substring, or named list of such.}

\item{open}{The opening delimiter.}

\item{close}{The closing delimiter.}
}
\description{
substitute substrings using strings or replacement functions
}
\examples{
unglue_sub(
  c("a and b", "foo or bar"),
  c("{x} and {y}", "{x} or {z}"),
  "XXX")

unglue_sub(
  c("a and b", "foo or bar"),
  c("{x} and {y}", "{x} or {z}"),
  toupper)

unglue_sub(
  c("a and b", "foo or BAR"),
  c("{x} and {y}", "{x} or {z}"),
  list(x= "XXX", y = toupper, z = tolower))

}
