% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_long2wide}
\alias{umx_long2wide}
\title{Take a long twin-data file and make it wide (one family per row)}
\usage{
umx_long2wide(
  data,
  famID = NA,
  twinID = NA,
  zygosity = NA,
  vars2keep = NA,
  passalong = NA,
  twinIDs2keep = NA
)
}
\arguments{
\item{data}{The original (long-format) data file}

\item{famID}{The unique identifier for members of a family}

\item{twinID}{The twinID. Typically 1, 2, 50 51, etc...}

\item{zygosity}{Typically MZFF, DZFF MZMM, DZMM DZOS}

\item{vars2keep}{= The variables you wish to analyse (these will be renamed with paste0("_T", twinID)}

\item{passalong}{= Variables you wish to pass-through (keep, even though not twin vars)}

\item{twinIDs2keep}{= If NA (the default) all twinIDs are kept, else only those listed here. Useful to drop sibs.}
}
\value{
\itemize{
\item dataframe in wide format
}
}
\description{
\code{umx_long2wide} merges on \code{famID}. Family members are ordered by \code{twinID}.

twinID is equivalent to birth order. Up to 10 twinIDs are allowed (family order).

\emph{Note}: Not all data sets have an order column, but it is essential to rank subjects correctly.

You might start off with a TWID which is a concatenation of a familyID and a 2 digit twinID

\strong{Generating famID and twinID as used by this function}

You can capture the last 2 digits with the \code{mod} function: \code{twinID = df$TWID \%\% 100}

You can \emph{drop} the last 2 digits with integer div: \code{famID = df$TWID \%/\% 100}

\emph{Note}: The functions assumes that if zygosity or any passalong variables are NA in the first
family member, they are NA everywhere. i.e., it does not hunt for values that
are present elsewhere or try and self-heal missing data.
}
\examples{
\dontrun{
# ==============================================
# = First make a long format file for the demo =
# ==============================================
data(twinData)
tmp = twinData[, -2]
tmp$twinID1 = 1; tmp$twinID2 = 2
long = umx_wide2long(data = tmp, sep = "")
str(long)
# 'data.frame':	7616 obs. of  11 variables:
#  $ fam     : int  1 2 3 4 5 6 7 8 9 10 ...
#  $ zyg     : int  1 1 1 1 1 1 1 1 1 1 ...
#  $ part    : int  2 2 2 2 2 2 2 2 2 2 ...
#  $ cohort  : chr  "younger" "younger" "younger" "younger" ...
#  $ zygosity: Factor w/ 5 levels "MZFF","MZMM",..: 1 1 1 1 1 1 1 1 1 1 ...
#  $ wt      : int  58 54 55 66 50 60 65 40 60 76 ...
#  $ ht      : num  1.7 1.63 1.65 1.57 1.61 ...
#  $ htwt    : num  20.1 20.3 20.2 26.8 19.3 ...
#  $ bmi     : num  21 21.1 21 23 20.7 ...
#  $ age     : int  21 24 21 21 19 26 23 29 24 28 ...
#  $ twinID  : num  1 1 1 1 1 1 1 1 1 1 ...

# OK. Now to demo long2wide...

# Keeping all columns
wide = umx_long2wide(data= long, famID= "fam", twinID= "twinID", zygosity= "zygosity")
namez(wide) # some vars, like part, should have been passed along instead of made into "part_T1"

# ======================================
# = Demo requesting specific vars2keep =
# ======================================

# Just keep bmi and wt
wide = umx_long2wide(data= long, famID= "fam", twinID= "twinID", 
    zygosity = "zygosity", vars2keep = c("bmi", "wt")
)

namez(wide)
# "fam" "twinID" "zygosity" "bmi_T1" "wt_T1" "bmi_T2" "wt_T2"

# ==================
# = Demo passalong =
# ==================
# Keep bmi and wt, and pass through 'cohort'
wide = umx_long2wide(data= long, famID= "fam", twinID= "twinID", zygosity= "zygosity", 
	vars2keep = c("bmi", "wt"), passalong = "cohort"
)
namez(wide)

}

}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=merge]{merge()}}
}

Other Twin Data functions: 
\code{\link{umx}},
\code{\link{umx_make_TwinData}()},
\code{\link{umx_make_twin_data_nice}()},
\code{\link{umx_residualize}()},
\code{\link{umx_scale_wide_twin_data}()},
\code{\link{umx_wide2longTwinData}()}
}
\concept{Twin Data functions}
