% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getFilteredData}
\alias{getFilteredData}
\title{Method for retrieving filtered data}
\usage{
getFilteredData(
  object,
  name = "default",
  save = FALSE,
  outDir = getwd(),
  fileName = NULL,
  delim = ";"
)
}
\arguments{
\item{object}{Requires a UMI sample or UMI experiment object.}

\item{name}{String. Name of the filter. Default is "default".}

\item{save}{Logical, should data be saved as csv file? Default is FALSE.}

\item{outDir}{Output directory}

\item{fileName}{Filename to be used, default is the same as 'name'}

\item{delim}{Character string denoting delimiter to be used, default is ';'.}
}
\value{
A filtered consensus table, as a tibble.
}
\description{
Method for retrieving filtered data
}
\examples{
library(umiAnalyzer)

main = system.file('extdata', package = 'umiAnalyzer')

samples <- list.dirs(path = main, full.names = FALSE, recursive = FALSE)

simsen <- createUmiExperiment(experimentName = 'simsen',mainDir = main,sampleNames = samples)
simsen <- filterUmiObject(simsen)

myfilter <- getFilteredData(simsen)
myfilter

}
