% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{AmpliconHeatmap}
\alias{AmpliconHeatmap}
\title{Amplicon heatmap}
\usage{
AmpliconHeatmap(
  object,
  filter.name = "default",
  cut.off = 5,
  left.side = "columns",
  amplicons = NULL,
  samples = NULL,
  abs.count = FALSE,
  font.size = 10
)
}
\arguments{
\item{object}{Requires a UMI sample or UMI experiment object}

\item{filter.name}{Name of the filter to be plotted.}

\item{cut.off}{How many variant reads are necessary to consider a variant above background? Default is 5 reads.}

\item{left.side}{Show assays or sample on the left side of the heatmap. Default is assays}

\item{amplicons}{(Optional) character vector of amplicons to be plotted.}

\item{samples}{(Optional) character vector of samples to be plotted.}

\item{abs.count}{Logical. Should absolute counts be used instead of frequencies?}

\item{font.size}{Font size to use for sample labels}
}
\value{
A graphics object
}
\description{
Generates a heatmap of mutations with sample clustering using pheatmap.
}
\examples{
\dontrun{
library(umiAnalyzer)

main = system.file('extdata', package = 'umiAnalyzer')
samples <- list.dirs(path = main, full.names = FALSE, recursive = FALSE)
simsen <- createUmiExperiment(experimentName = 'example',mainDir = main,sampleNames = samples)
simsen <- filterUmiObject(simsen)

hmap <- AmpliconHeatmap(simsen)
}

}
