% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crime-at-location.R, R/ukpolice-deprecated.R
\name{ukc_crime_loc}
\alias{ukc_crime_loc}
\alias{ukc_crime_coord}
\alias{ukc_crime_poly}
\alias{ukc_crime_location}
\title{Crimes at a specific location}
\usage{
ukc_crime_loc(location, date = NULL, ...)

ukc_crime_coord(lat, lng, date = NULL, ...)

ukc_crime_poly(poly_df, date = NULL, ...)

ukc_crime_location(lat, lng, location, date = NULL, ...)
}
\arguments{
\item{location}{If specified, \code{lat} and \code{lng} are ignored. Location IDs are
available through other methods including \code{\link[=ukc_street_crime]{ukc_street_crime()}}.}

\item{date}{The year and month in "YYYY-MM" form. If \code{NULL}, latest
available month will be returned. Also accepts dates in formats that can be
coerced to \code{Date} class with \code{as.Date()}.}

\item{...}{further arguments passed to \code{\link[httr:GET]{httr::GET}}.}

\item{lat}{Latitude. Accepts a single value.}

\item{lng}{Longitude. Accepts a single value.}

\item{poly_df}{a dataframe containing the lat/lng pairs which define
the boundary of the custom area, or a \code{\link[sf:sf]{sf}} or
\code{\link[sp:SpatialPointsDataFrame]{SpatialPointsDataFrame}} object.
The first and last coordinates need not be the same — they will be joined
by a straight line once the request is made. If a dataframe, the lat/lng
must be the first two columns, or named \code{"lat"} and \code{"lng"}.}
}
\value{
A \code{tibble} with details of crimes at a given location.
}
\description{
Returns details of crimes within a one mile radius of a given point, at a
specific location ID, or from within a custom polygon.
}
\details{
If specified, \code{lat} and \code{lng} must be the same length. \code{location}
or both \code{lat} and \code{lng} must be specified.
}
\note{
The API will return a 400 status code in response to a GET request
longer than 4094 characters.
}
\examples{
\dontrun{
x <- ukc_crime_location(lat = 52, lng = 0)

y <- ukc_crime_location(location = 802171)

poly_df_3 <- data.frame(
  lat = c(52.268, 52.794, 52.130),
  lng = c(0.543, 0.238, 0.478)
)

z <- ukc_crime_poly(poly_df_3)
}

}
