% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_fetch_set}
\alias{system_fetch_set}
\title{Fetch Mathematical Set}
\usage{
system_fetch_set(cfg, set_name = NULL)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{set_name}{name of mathematical set}
}
\value{
A sequence containing the elements of the parameter set or NULL if if there was a problem.
}
\description{
Fetch the elements of the specified mathematical set that was defined in the system file.
}
\examples{
\donttest{
# Creating a system file from the pbpk example
fr = system_new(file_name        = "system.txt", 
                system_file      = "pbpk", 
                overwrite        = TRUE, 
                output_directory = tempdir())

# Building the system 
cfg = build_system(system_file  = file.path(tempdir(), "system.txt"),
      output_directory          = file.path(tempdir(), "output"),
      temporary_directory       = tempdir())

# Fetching the contents of the ORG mathematical set
ORG_elements = system_fetch_set(cfg, "ORG")
}
}
