% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{nm_select_records}
\alias{nm_select_records}
\title{Select Records from NONMEM-ish Data Set}
\usage{
nm_select_records(cfg, values, filter)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{values}{dataframe containing the dataset with column headers}

\item{filter}{list with element names as headers for \code{values} with values from the same header OR'd and values across headers AND'd}
}
\value{
subset of dataset
}
\description{
Retrieves a subset of a NONMEM-ish data set based on a list containing filtering information.
}
\details{
If the dataset has the headings \code{ID}, \code{DOSE} and \code{SEX}  and
\code{filter} has the following format:

\preformatted{
filter = list()
filter$ID   = c(1:4)
filter$DOSE = c(5,10)
filter$SEX  = c(1)
}

It would be translated into the boolean filter:

\preformatted{
((ID==1) | (ID==2) | (ID==3) | (ID==4)) & ((DOSE == 5) | (DOSE==10)) & (SEX == 1)
}
}
\keyword{internal}
