% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculFastSpectral_p.r
\name{KpartitionNJW}
\alias{KpartitionNJW}
\title{KpartitionNJW function}
\usage{
KpartitionNJW(similarity, K)
}
\arguments{
\item{similarity}{matrix of similarity.}

\item{K}{number of clusters.}
}
\value{
The function returns a list containing:
\item{label}{vector of cluster sequencing.}
\item{centres}{matrix of cluster centers in the space of the K first normalised eigen vectors.}
\item{vecteursPropresProjK}{matrix containing, in columns, the K first normalised eigen vectors of the similarity matrix.}
\item{valeursPropresK}{vector containing the K first eigen values of the similarity matrix.}
\item{vecteursPropres}{matrix containing, in columns, eigen vectors of the similarity matrix.}
\item{valeursPropres}{vector containing eigen values of the similarity matrix.}
\item{inertieZ}{vector of within-cluster sum of squares, one component per cluster.}
}
\description{
Perform spectral classification on the similarity matrix of a dataset (Ng et al. (2001) algorithm), using kmeans algorithm on data projected in the space of its K first eigen vectors.
}
\examples{

#####
x <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))

similarity<-ZPGaussianSimilarity(x,7)
similarity=similarity\%*\%t(similarity)
sp<-KpartitionNJW(similarity,3)
plot(x,col=sp$label)

#####    
x <- rbind(data.frame(x=1:100+(runif(100)-0.5)*2,y=runif(100)/5), 
           data.frame(x=1:100+(runif(100)-0.5)*2,y=runif(100)/5+1),
           data.frame(x=1:100+(runif(100)-0.5)*2,y=runif(100)/5+2))

similarity<-ZPGaussianSimilarity(x,7)
similarity=similarity\%*\%t(similarity)
sp<-KpartitionNJW(similarity,3)
plot(x,col=sp$label)

#####
x=(runif(1000)*4)-2;y=(runif(1000)*4)-2
keep<-which((x**2+y**2<0.5)|(x**2+y**2>1.5**2 & x**2+y**2<2**2 ))
data<-data.frame(x,y)[keep,]

similarity=ZPGaussianSimilarity(data, 7)
similarity=similarity\%*\%t(similarity)
sp<-KpartitionNJW(similarity,2)

plot(data,col=sp$label)

}
\references{
Ng Andrew, Y., M. I. Jordan, and Y. Weiss. "On spectral clustering: analysis and an algorithm [C]." Advances in Neural Information Processing Systems (2001).
}

