% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculFastSpectral_p.r
\name{KmeansAutoElbow}
\alias{KmeansAutoElbow}
\title{KmeansAutoElbow function}
\usage{
KmeansAutoElbow(features, Kmax, StopCriteria = 0.99, graph = FALSE)
}
\arguments{
\item{features}{dataframe or matrix of raw data.}

\item{Kmax}{maximum number of clusters allowed.}

\item{StopCriteria}{elbow method cumulative explained variance > criteria to stop K-search. (???)}

\item{graph}{boolean, if TRUE figures are plotted.}
}
\value{
The function returns a list containing the following components:
\item{K}{number of clusters in data according to explained variance and kmeans algorithm.}
\item{res.kmeans}{an object of class "kmeans" (see \code{\link[stats]{kmeans}}) containing classification results.}
}
\description{
KmeansAutoElbow performs k-means clustering on a dataframe with selection of optimal number of clusters using elbow criteria.
}
\details{
KmeansAutoElbow returns partition and K number of groups according to kmeans clustering and Elbow method
}
\examples{
x <- rbind(matrix(rnorm(300, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
colnames(x) <- c("x", "y")
km<-KmeansAutoElbow(x,round(dim(x)/25,0)[1],StopCriteria=0.99,graph=TRUE)
plot(x,col=km$res.kmeans$cluster)
points(km$res.kmeans$centers, col = 1:km$K, pch = 16)

}
\seealso{
\code{\link[stats]{kmeans}}
}

