% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eifs.R
\name{ipcw_eif_update}
\alias{ipcw_eif_update}
\title{Iterative IPCW Update Procedure of Augmented Efficient Influence Function}
\usage{
ipcw_eif_update(
  data_internal,
  C_samp,
  V,
  ipc_mech,
  ipc_weights,
  Qn_estim,
  Hn_estim,
  estimator = c("tmle", "onestep"),
  fluctuation = NULL,
  flucmod_tol = 50,
  eif_reg_type = c("hal", "glm")
)
}
\arguments{
\item{data_internal}{A \code{data.table} containing of the observations
selected into the second-phase sample.}

\item{C_samp}{A \code{numeric} indicator for missingness due to exclusion
the from second-stage sample.}

\item{V}{A \code{data.table} giving the values across all observations of
all variables that play a role in the censoring mechanism.}

\item{ipc_mech}{A \code{numeric} vector of the censoring mechanism estimates
all of the observations, only for the two-phase sampling mechanism. Note
well that these values do NOT account for censoring from loss to follow-up.}

\item{ipc_weights}{A \code{numeric} vector of inverse probability of
censoring weights, including such weights for censoring due to loss to
follow-up. Without loss to follow-up, these are equivalent to \code{C_samp
/ ipc_mech} in an initial run of this procedure.}

\item{Qn_estim}{A \code{data.table} corresponding to the outcome regression.
This is produced by invoking the internal function \code{est_Q}.}

\item{Hn_estim}{A \code{data.table} corresponding to values produced in the
computation of the auxiliary ("clever") covariate. This is produced easily
by invoking the internal function \code{est_Hn}.}

\item{estimator}{The type of estimator to be fit, either \code{"tmle"} for
targeted maximum likelihood estimation or \code{"onestep"} for a one-step
estimator.}

\item{fluctuation}{A \code{character} giving the type of regression to be
used in traversing the fluctuation submodel. The choices are "weighted" and
"standard".}

\item{flucmod_tol}{A \code{numeric} indicating the largest value to be
tolerated in the fluctuation model for the targeted minimum loss estimator.}

\item{eif_reg_type}{Whether a flexible nonparametric function ought to be
used in the dimension-reduced nuisance regression of the targeting step for
the censored data case. By default, the method used is a nonparametric
regression based on the Highly Adaptive Lasso (from \pkg{hal9001}). Set
this to \code{"glm"} to instead use a simple linear regression model. In
this step, the efficient influence function (EIF) is regressed against
covariates contributing to the censoring mechanism (i.e., EIF ~ V | C = 1).}
}
\value{
A \code{list} containing the estimated outcome mechanism, the fitted
 fluctuation model for TML updates, the updated inverse probability of
 censoring weights (IPCW), the updated estimate of the efficient influence
 function, and the estimated IPCW component of the EIF.
}
\description{
Iterative IPCW Update Procedure of Augmented Efficient Influence Function
}
\details{
An adaptation of the IPCW-TMLE for iteratively constructing an
 efficient inverse probability of censoring weighted TML or one-step
 estimator. The efficient influence function of the parameter and updating
 the IPC weights in an iterative process, until a convergence criteria is
 satisfied.
}
