% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_long.R
\name{to_long}
\alias{to_long}
\alias{to_wide}
\title{Reshape a data.frame or matrix to a long data.frame}
\usage{
to_long(wide, rowname = NULL, colname = NULL,
  responseName = deparse(substitute(wide)), varNames = c("Row", "Col"))

to_wide(long, row = 1, col = 2, response = 3)
}
\arguments{
\item{wide}{A data.frame or matrix in wide form}

\item{rowname}{Name for the row variable}

\item{colname}{Name for the column variable}

\item{responseName}{Name for the response variable.  If \code{wide} is a matrix with an attribute that begins with
\code{"response"}, that value is taken as the \code{responseName}.  Otherwise, the name of the \code{wide}
object is used.}

\item{varNames}{Default names for the row and column variables if not passed as \code{rowname} or \code{colname}}

\item{long}{A data.frame in long form}

\item{row}{Column index or quoted name of the row variable}

\item{col}{Column index or quoted name of the column variable}

\item{response}{Column index or quoted name of the response variable}
}
\value{
A data.frame in long format
}
\description{
Reshape a data.frame or matrix to a long data.frame

Reshape a data.frame or matrix to a wide data.frame
}
\examples{
Arizona.long <- to_long(Arizona, varNames=c("Month", "City"))
Arizona.long

Arizona.long <- to_long(Arizona, varNames=c("Month", "City"))
# back the other way
to_wide(Arizona.long)
}
\author{
Michael Friendly and Richard M. Heiberger

Michael Friendly and Richard M. Heiberger
}
