% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R
\name{sensitivity}
\alias{sensitivity}
\title{Function to run sensitivity analysis described in Ridgeway's paper;
currently works only for ATT.}
\usage{
sensitivity(ps1, data, outcome, order.by.importance = TRUE, verbose = TRUE)
}
\arguments{
\item{ps1}{A `ps` object.}

\item{data}{The dataset including the outcomes}

\item{outcome}{The outcome of interest.}

\item{order.by.importance}{Orders the output by relative importance of covariates.}

\item{verbose}{If `TRUE`, extra information will be printed.}
}
\value{
Returns the following
  * `tx` Summary for treated observations.
  * `ctrl` Summary for control observations.
}
\description{
Performs the sensitivity analyses described in Ridgeway (2006).
This is a beta version of this functionality. Please let the developers
know if you have problems with it.
}
\references{
Ridgeway, G. (2006). "The effect of race bias in post-traffic stop
  outcomes using propensity scores", *Journal of Quantitative Criminology* 22(1):1-29.
}
