% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc.effects.mediation.R
\name{desc.effects.mediation}
\alias{desc.effects.mediation}
\title{Describe the effects from a mediation object}
\usage{
\method{desc.effects}{mediation}(x, y_outcome = NULL, ...)
}
\arguments{
\item{x}{A mediation object}

\item{y_outcome}{The outcome; if \code{NULL},
then Y must have been provided to the
original mediation function.}

\item{...}{Additional arguments..}
}
\value{
\item{results}{effects, standard errors,
and confidence intervals of a mediation object}
}
\description{
Describe the effects, and calculate standard
errors and confidence intervals from a mediation object
}
\examples{
data("tMdat")

## tMdat is small simulated data set included in twangMediation for 
## demonstrating the functions. See ?tMdat for details

fit.es.max <- wgtmed(M ~ w1 + w2 + w3,
                      data = tMdat,
                      a_treatment = "A",
                      y_outcome = "Y",
                      total_effect_wts = tMdat$te.wgt,
                      method = "ps",
                      ps_n.trees=1500,
                      ps_shrinkage=0.01,
                      ps_stop.method=c("es.max")
                      )

desc.effects(fit.es.max)
}
\seealso{
\code{\link{desc.effects}}, \code{\link{wgtmed}}
}
