% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootci_tvm_3trt.R
\name{bootci_tvm_3trt}
\alias{bootci_tvm_3trt}
\title{Bootstrap samples to estimate confidence intervals for continuous outcome and three 
treatment groups.}
\usage{
bootci_tvm_3trt(boot.sample, orig.data, t.est)
}
\arguments{
\item{boot.sample}{number of replicates for bootstrapping confidence intervals. 
Default = 1000.}

\item{orig.data}{a list of original data \code{T1}, \code{T2}, \code{mediator}, 
\code{outcome} and \code{t.seq}.}

\item{t.est}{time points at which to make the estimation. Default = t.seq.}
}
\value{
\item{plw1}{CI lower limit for estimated mediation effect of T1}

\item{pup1}{CI upper limit for estimated mediation effect of T1}

\item{plw2}{CI lower limit for estimated mediation effect of T2}

\item{pup2}{CI upper limit for estimated mediation effect of T2}

\item{orig.se1.all}{estimated standard errors for the mediation effect of T1}

\item{orig.se2.all}{estimated standard errors for the mediation effect of T2}

\item{orig.mediation1}{time varying mediation effect for T1}

\item{orig.mediation2}{time varying mediation effect for T2}
}
\description{
Internal function for estimating bootstrapped confidence intervals for the mediation 
effect of continuous outcome and three treatment groups when user argument 
\code{CI="boot"}.
}
