% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootci_coeff_3trt.R
\name{bootci_coeff_3trt}
\alias{bootci_coeff_3trt}
\title{Bootstrap samples to estimate confidence intervals for coefficients for a continuous 
outcome and three treatment groups.}
\usage{
bootci_coeff_3trt(
  T1,
  T2,
  t.seq,
  mediator,
  outcome,
  t.est,
  original.coeff,
  boot.sample = 1000
)
}
\arguments{
\item{T1}{a vector indicating assignment to treatment 1}

\item{T2}{a vector indicating assignment to treatment 2}

\item{t.seq}{a vector of time points for each observation}

\item{mediator}{matrix of mediator values in wide format}

\item{outcome}{matrix of outcome values in wide format}

\item{t.est}{time points at which to make the estimation. Default = t.seq}

\item{original.coeff}{a list of the estimated coefficients.}

\item{boot.sample}{number of replicates for bootstrapping confidence intervals. 
Default = 1000.}
}
\value{
\item{alw1}{CI lower limit for estimated Treatment 1 effect on mediator}

\item{aup1}{CI upper limit for estimated Treatment 1 effect on mediator}

\item{alw2}{CI lower limit for estimated Treatment 2 effect on mediator}

\item{aup2}{CI upper limit for estimated Treatment 2 effect on mediator}

\item{glw1}{CI lower limit for estimated Treatment 1 direct effect on outcome}

\item{gup1}{CI upper limit for estimated Treatment 1 direct effect on outcome}

\item{glw2}{CI lower limit for estimated Treatment 2 direct effect on outcome}

\item{gup2}{CI upper limit for estimated Treatment 2 direct effect on outcome}

\item{tlw1}{CI lower limit for estimated Treatment 1 total effect on outcome}

\item{tup1}{CI upper limit for estimated Treatment 1 total effect on outcome}

\item{tlw2}{CI lower limit for estimated Treatment 2 total effect on outcome}

\item{tup2}{CI upper limit for estimated Treatment 2 total effect on outcome}

\item{blw}{CI lower limit for estimated effect of mediator on outcome}

\item{bup}{CI upper limit for estimated effect of mediator on outcome}
}
\description{
Part of the set of internal functions for estimating bootstrapped confidence intervals 
for the coefficients of the mediation model for a continuous outcome and three treatment 
groups.
}
