% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fvYearAnnuityCompQuarterly.R
\name{fvYearlyAnnuityCompQuarterly}
\alias{fvYearlyAnnuityCompQuarterly}
\title{Calculates Future Value of Yearly Paid Ordinary Annuity or Annuity Due that is Compounded Quarterly.}
\usage{
fvYearlyAnnuityCompQuarterly(r, n, pmt, bgn)
}
\arguments{
\item{r}{A number.}

\item{n}{A number.}

\item{pmt}{A number.}

\item{bgn}{A number.}
}
\value{
Input values to four arguments \code{r} , \code{n} , \code{pmt} and \code{bgn}.
}
\description{
Calculates Future Value of Yearly Paid Ordinary Annuity or Annuity Due that is Compounded Quarterly.
}
\details{
According to \insertCite{humm;textual}{tvmComp}, Annuities are classified by the date of payment. In an Ordinary Annuity, payments are made at the end of each payment period. In an Annuity Due, payments are made at the beginning of each payment period. Loan payments, mortgage payments, and interest payments on bonds are all examples of Ordinary Annuities. Examples of annuities due include lease rental payments on real estate or equipment.
The method \code{fvYearlyAnnuityCompQuarterly()}is developed to calculate Future Value of Yearly-Paid Ordinary Annuity or Annuity Due that is Compounded Quarterly. The method gives Future Value when values are passed to its four arguments. Here \code{r} is annual rate, \code{n} is number of years, \code{pmt} is amount of one annuity and \code{bgn} is the computational mode. (Enter 1 when annuity payment occurs at the beginning of the period; 0 for end of period payments
}
\examples{
fvYearlyAnnuityCompQuarterly(0.11,4,-300,0)
fvYearlyAnnuityCompQuarterly(0.11,4,-300,1)
fvYearlyAnnuityCompQuarterly(0.11,4,300,0)
fvYearlyAnnuityCompQuarterly(0.11,4,300,1)
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
#'@references
\insertRef{humm}{tvmComp}
}
