% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additive.tvcure2.R
\name{additive.tvcure}
\alias{additive.tvcure}
\title{Extract additive term estimates from a tvcure object.}
\usage{
additive.tvcure(obj.tvcure, ngrid = 300, ci.level = 0.95)
}
\arguments{
\item{obj.tvcure}{a \code{\link{tvcure.object}}.}

\item{ngrid}{number of gridpoints where the fitted additive terms are evaluated.}

\item{ci.level}{confidence level for the pointwise credible intervals of the additive terms.}
}
\value{
A list with following elements:
\itemize{
\item \code{f0} : a function estimate of \eqn{f_0}.
\item \code{F0} : a function estimate of \eqn{F_0}.
\item \code{T} : the follow-up time after which a unit is considered `cured'.
\item \code{nfixed1} : the number of non-penalized regression parameter in the long-term term (or quantum) submodel.
\item \code{J1} : number of additive terms in the long-term term (or quantum) submodel.
\item \code{additive.lab1} : labels of the additive terms in the long-term term (or quantum) submodel.
\item \code{K1} : number of P-spline parameters per additive term in the long-term term (or quantum) submodel.
\item \code{knots1} : list of length J1 containing the knots of the additive term in the long-term term (or quantum) submodel.
\item \code{f1.grid} : list of length J1 containing for each additive term in the long-term term (or quantum) submodel, a list of length 3 with elements <x>, <y.mat> and <y.mat2>
\itemize{
\item Element <x> is a vector of \code{ngrid} equidistant values covering the range of values for the covariate ;
\item <y.mat> is (ngrid x 3) matrix containing in column 1 the estimated values of the additive term at <x> and the bounds of the pointwise credible interval for it in the other 2 columns.
\item <y.mat2> is (ngrid x 3) matrix containing in column 1 the estimated values of the additive term at <x> and the bounds of the simultaneous credible region for it in the other 2 columns.
}
\item \code{f1} : list of length J1 containing the estimated function of the corresponding additive term in the long-term term (or quantum) submodel.
\item \code{f1.se} : list of length J1 containing the estimated standard error function of the corresponding additive term in the long-term term (or quantum) submodel.
}

The same definitions applies for \code{nfixed2}, \code{J2}, \code{additive.lab2}, \code{K2}, \code{knots2},
\code{f2.grid}, \code{f2}, \code{f2.se} with the additive terms in the short-term (or timing) submodel.
}
\description{
Extract additive term estimates from a tvcure object.
}
\examples{
\donttest{
require(tvcure)
## Simulated data generation
beta = c(beta0=.4, beta1=-.2, beta2=.15) ; gam = c(gam1=.2, gam2=.2)
data = simulateTVcureData(n=500, seed=123, beta=beta, gam=gam,
                          RC.dist="exponential",mu.cens=550)$rawdata
## TVcure model fitting
tau.0 = 2.7 ; lambda1.0 = c(40,15) ; lambda2.0 = c(25,70) ## Optional
model = tvcure(~z1+z2+s(x1)+s(x2), ~z3+z4+s(x3)+s(x4), data=data,
               tau.0=tau.0, lambda1.0=lambda1.0, lambda2.0=lambda2.0)

## Extract additive term estimates from tvcure object
obj = additive.tvcure(model)
names(obj)
}

}
\references{
Lambert, P. and Kreyenfeld, M. (2025).
Time-varying exogenous covariates with frequently changing values in double additive cure survival model: an application to fertility.
\emph{Journal of the Royal Statistical Society, Series A}. <doi:10.1093/jrsssa/qnaf035>
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
