% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_tutorial_defaults.R
\name{check_tutorial_defaults}
\alias{check_tutorial_defaults}
\title{Confirm that a tutorial has the recommended components}
\usage{
check_tutorial_defaults(
  tutorial_paths,
  libraries = c("learnr", "tutorial.helpers"),
  children = c("info_section", "download_answers")
)
}
\arguments{
\item{tutorial_paths}{Character vector of the paths to the tutorials to be
examined.}

\item{libraries}{Character vector of library names that should be loaded
in the tutorial. The function looks for \code{library(name)} calls. Default
is \code{c("learnr", "tutorial.helpers")}.}

\item{children}{Character vector of child document names (without the .Rmd
extension) that should be included in the tutorial. The function looks
for these in child document inclusion chunks. Default is
\code{c("info_section", "download_answers")}.}
}
\value{
No return value, called for side effects.
}
\description{
Checks that tutorials contain required libraries and child
documents. The function looks for library() calls and child document
inclusions in the tutorial files.
}
\examples{
  # Check with default requirements
  check_tutorial_defaults(
    tutorial_paths = return_tutorial_paths("tutorial.helpers")
  )
  
  # Check for specific libraries only
  check_tutorial_defaults(
    tutorial_paths = return_tutorial_paths("tutorial.helpers"),
    libraries = c("learnr", "knitr"),
    children = c("copy_button")
  )

}
