% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vreq_classic_ag_methods.R
\name{vreq_classic_ag_methods}
\alias{vreq_classic_ag_methods}
\alias{summary.vreq_classic_ag}
\alias{print.vreq_classic_ag}
\alias{set_com.vreq_classic_ag}
\alias{set_comnull.vreq_classic_ag}
\alias{set_vr.vreq_classic_ag}
\alias{set_ts.vreq_classic_ag}
\alias{get_com.vreq_classic_ag}
\alias{get_comnull.vreq_classic_ag}
\alias{get_vr.vreq_classic_ag}
\alias{get_ts.vreq_classic_ag}
\title{Basic methods for the \code{vreq_classic_ag} class}
\usage{
\method{summary}{vreq_classic_ag}(object, ...)

\method{print}{vreq_classic_ag}(x, ...)

\method{set_com}{vreq_classic_ag}(obj, newval)

\method{set_comnull}{vreq_classic_ag}(obj, newval)

\method{set_vr}{vreq_classic_ag}(obj, newval)

\method{set_ts}{vreq_classic_ag}(obj, newval)

\method{get_com}{vreq_classic_ag}(obj)

\method{get_comnull}{vreq_classic_ag}(obj)

\method{get_vr}{vreq_classic_ag}(obj)

\method{get_ts}{vreq_classic_ag}(obj)
}
\arguments{
\item{object, x, obj}{An object of class \code{vreq_classic_ag}}

\item{...}{Not currently used. Included for argument consistency
with existing generics.}

\item{newval}{A new value, for the \code{set_*} methods}
}
\value{
\code{summary.vreq_classic_ag} produces a summary of a \code{vreq_classic_ag} object.
A \code{print.vreq_classic_ag} method is also available. For \code{vreq_classic_ag} objects, 
\code{set_*} and \code{get_*} methods are available for all slots (see
the documentation for \code{aggts} for a list). The \code{set_*} methods 
just throw an error, to prevent breaking the consistency between the 
slots of a \code{vreq_classic_ag} object.
}
\description{
Set, get, summary, and print methods for the \code{vreq_classic_ag} class.
}
\examples{
X<-matrix(runif(10*100),10,100)
h<-tsvreq_classic(X)
inp<-aggts(h,h$ts[h$ts>4])
print(inp)
summary(inp)
 
}
\references{
Zhao et al, (In prep) Decomposition of the variance ratio illuminates timescale-specific
population and community variability.
}
\seealso{
\code{\link{aggts}}, \code{\link{tsvreq_classic}}, 
\code{\link{vreq_classic}}, \code{\link{vreq_LdM}}, \code{\link{vreq}}, 
\code{browseVignettes("tsvr")}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
