% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mseastest.R
\name{mseastest}
\alias{mseastest}
\title{Multiplicative seasonality test}
\usage{
mseastest(
  y,
  m = NULL,
  type = c("pearson", "spearman", "kendall"),
  cma = NULL,
  sn = 1,
  alpha = 0.05,
  outplot = c(0, 1, 2)
)
}
\arguments{
\item{y}{input time series. Can be \code{ts} object.}

\item{m}{seasonal period. If \code{y} is a \code{ts} object then the default is its frequency.}

\item{type}{type of correlation
\itemize{
\item{\code{"pearson"}}
\item{\code{"spearman"}}
\item{\code{"kendall"}}
}}

\item{cma}{input precalculated level/trend for the analysis. Use \code{NULL} to calculate internally.}

\item{sn}{number of seasonal periods of decreasing magnitude to consider for the test.}

\item{alpha}{significance level.}

\item{outplot}{type of output plot:
\itemize{
\item \code{0}: none.
\item \code{1}: scatter plot.
\item \code{2}: time series plot.
}}
}
\value{
A list with the following:
\itemize{
\item \code{is.multiplicative}: if \code{TRUE} the test found evidence of multiplicative seasonality.
\item \code{statistic}: test statistic.
\item \code{pvalue}: p-value of the test.
}
}
\description{
correlation based multiplicative seasonality test.
}
\examples{
mseastest(referrals)

}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}.
}
\keyword{htest}
\keyword{internal}
\keyword{ts}
