% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsriadditive.R
\name{tsriadditive}
\alias{tsriadditive}
\title{Fitting Additive Hazards Models with Two Stage Residual Inclusion Method}
\usage{
tsriadditive(survtime, cause = NULL, treatment = NULL, IV = NULL,
  covariates = NULL)
}
\arguments{
\item{survtime}{the event time}

\item{cause}{the indicator records the cause. Default to all one. Zero means right censoring. Greater than
or equal to two means other cause.}

\item{treatment}{the treatment variable, can be null}

\item{IV}{the instrumental variable}

\item{covariates}{all the observed confounders}
}
\value{
tsriadditive returns an object of class "tsriadditive".
An object of class "tsriadditive" is a list containing the following components:
\item{coef}{an estimate of the coefficients}
\item{baseline}{an estimate of the baseline hazards function}
\item{vcov}{an estimate of the variance covariance matrix of coef}
\item{byprod}{a byproduct, that will used by other functions}
}
\description{
tsriadditive is used to fit additive hazards models with two stage residual inclusion method.
}
\examples{
survtime <- rexp(100)
cause <- rbinom(100, 1, 0.7)
treatment <- rbinom(100, 1, 0.5)
IV <- rnorm(100)
covariates <- rnorm(100)
fit <- tsriadditive(survtime, cause, treatment, IV, covariates)
}
\references{
Ying, A., Xu, R. and Murphy, J. Two-Stage Residual Inclusion for Survival Data and Competing Risks - An
Instrumental Variable Approach with Application to SEER- Medicare Linked Data. Statistics in Medicine, 38(10): 1775-1801, 2019.
}
