% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gph.r
\name{GPH_estimate}
\alias{GPH_estimate}
\title{Classical and Robust Geweke and Porter-Hudak (GPH) estimators for the long-memory parameter d of a long-range dependent stationary processes}
\usage{
GPH_estimate(series, bandw.exp = 0.7, method = "GPH")
}
\arguments{
\item{series}{univariate time series}

\item{bandw.exp}{the bandwidth used in the regression equation}

\item{method}{character string giving the type of GPH to be computed. Allowed values are "\code{GPH}" (the default), "\code{GPH-M}" or "\code{GPH-Qn}".}
}
\value{
\code{d} GPH estimate

\code{sd.as} asymptotic standard deviation

\code{sd.reg} standard error deviation
}
\description{
Estimate the fractional (or “memory”) parameter d of long-range dependent stationary processes by the method of Geweke and Porter-Hudak (GPH). (GPH-M) and (GPH-Qn) correspond to the estimators devised by Reisen et al. (2017) and Molinares (2009), respectively.
}
\examples{
library(fracdiff)
simseries <- fracdiff.sim(1500, d = 0.3)
GPH_estimate(simseries$series,method="GPH")$d
\dontrun{
GPH_estimate(simseries$series,method="GPH-Qn")$d
GPH_estimate(simseries$series,method="GPH-M")$d
}
}
\references{
Reisen, V. A. and Lévy-Leduc, C. and Taqqu, M. (2017) An M-estimator for the long-memory parameter. \emph{To appear in Journal of Statistical Planning and Inference}.

Molinares, F. F. and Reisen, V. A., and Cribari-Neto, F. (2009) Robust estimation in long-memory processes under additive outliers. \emph{Journal of Statistical Planning and Inference}, \bold{139}, 2511--2525.
#' @references Geweke, J. and Porter-Hudak, S. (1983) The estimation and application of long memory time series models. \emph{Journal of Time Series Analysis}, \bold{4}, 221--238.
}
\author{
Valderio Reisen, Céline Lévy-Leduc and Higor Cotta.
}
