% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_gy_ci}
\alias{plot_gy_ci}
\title{Plots the growth rates and slope of the log cumulative growth rate}
\usage{
plot_gy_ci(
  res,
  plt.start.date = NULL,
  smoothed = FALSE,
  title = NULL,
  series.name = NULL,
  pad.right = NULL
)
}
\arguments{
\item{res}{Results object estimated using the \code{estimate()} method.}

\item{plt.start.date}{Plot start date. Default is \code{NULL} which is the
start of the estimation sample.}

\item{smoothed}{Logical value indicating whether to used the smoothed
estimates of \eqn{\delta} and \eqn{\gamma}. Default is \code{FALSE}, in
which case the filtered estimates are returned.}

\item{title}{Title for plot. Enter as text string. \code{NULL}
(i.e. no title) by default.}

\item{series.name}{The name of the series the growth rate is being computed
for. E.g. \code{'New cases'}.}

\item{pad.right}{Numerical value for the amount of time periods of blank
space you wish to leave on the right of the graph. Extends the horizontal
axis by the given number of time periods.}
}
\value{
A \code{ggplot2} plot.
}
\description{
Plots the smoothed/filtered growth rate of the difference in the
cumulated variable (\eqn{g_y}) and the associated confidence intervals.
}
\examples{
library(tsgc)
data(gauteng,package="tsgc")
idx.est <- zoo::index(gauteng) <= as.Date("2020-07-20")

# Specify a model
model <- SSModelDynamicGompertz$new(Y = gauteng[idx.est], q = 0.005)
# Estimate a specified model
res <- model$estimate()

# Plot filtered gy, g and gamma
plot_gy_ci(res, plt.start.date = as.Date("2020-07-13"))

}
