% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yanfei.R
\name{nonlinearity}
\alias{nonlinearity}
\title{Nonlinearity coefficient}
\usage{
nonlinearity(x)
}
\arguments{
\item{x}{a univariate time series}
}
\value{
A numeric value.
}
\description{
Computes a nonlinearity statistic based on Lee, White & Granger's nonlinearity test of a time series.
The statistic is \eqn{10X^2/T}{10X^2/T} where \eqn{X^2}{X^2} is the Chi-squared statistic from Lee, White and Granger,
and T is the length of the time series. This takes large values
when the series is nonlinear, and values around 0 when the series is linear.
}
\examples{
nonlinearity(lynx)
}
\references{
Lee, T. H., White, H., & Granger, C. W. (1993). Testing for neglected nonlinearity in time series models: A comparison of neural network methods and alternative tests. \emph{Journal of Econometrics}, 56(3), 269-290.

Teräsvirta, T., Lin, C.-F., & Granger, C. W. J. (1993). Power of the neural network linearity test. \emph{Journal of Time Series Analysis}, 14(2), 209–220.
}
\author{
Yanfei Kang and Rob J Hyndman
}
