% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_source_priors_params.R
\name{one_source_priors_params}
\alias{one_source_priors_params}
\title{Adjust Bayesian priors - One Source Trophic Position}
\usage{
one_source_priors_params(
  n1 = NULL,
  n1_sigma = NULL,
  dn = NULL,
  dn_sigma = NULL,
  tp_lb = NULL,
  tp_ub = NULL,
  sigma_lb = NULL,
  sigma_ub = NULL,
  bp = FALSE
)
}
\arguments{
\item{n1}{mean (\eqn{\mu}) prior for the mean \eqn{\delta^{15}}N baseline.
Defaults to \code{9}.}

\item{n1_sigma}{variance (\eqn{\sigma}) for the mean \eqn{\delta^{15}}N
baseline. Defaults to \code{1}.}

\item{dn}{mean (\eqn{\mu}) prior value for \eqn{\Delta}N. Defaults to \code{3.4}.}

\item{dn_sigma}{variance (\eqn{\sigma}) for \eqn{\delta^{15}}N.
Defaults to \code{0.25}.}

\item{tp_lb}{lower bound prior for trophic position. Defaults to \code{2}.}

\item{tp_ub}{upper bound prior for trophic position. Defaults to \code{10}.}

\item{sigma_lb}{lower bound prior for \eqn{\sigma}. Defaults to \code{0}.}

\item{sigma_ub}{upper bound prior for \eqn{\sigma}. Defaults to \code{10}.}

\item{bp}{logical value that controls whether informed priors are
supplied to the model for \eqn{\delta^{15}}N baseline. Default is
\code{FALSE} meaning the model will use uninformed priors, however, the supplied
\code{data.frame} needs values for \eqn{\delta^{15}}N baseline (\code{n1}).}
}
\value{
\code{stanvars} object to be used with \code{brms()} call.
}
\description{
Adjust priors for one source trophic position model derived from \href{https://esajournals.onlinelibrary.wiley.com/doi/full/10.1890/0012-9658\%282002\%29083\%5B0703\%3AUSITET\%5D2.0.CO\%3B2}{Post 2002}.
}
\details{
\deqn{\delta^{15}N = \delta^{15} N_1 + \delta N \times (tp - \lambda_1)}

This function allows the user to adjust the priors for the following variables
in the equation above:

\itemize{
\item The mean (\code{n1}; \eqn{\mu}) and variance (\code{n1_sigma}; \eqn{\sigma}) for
the mean \eqn{\delta^{15}}N for a given baseline (\eqn{\delta^{15}N_1}).
This prior assumes a normal distribution.
\item The mean (\code{dn}; \eqn{\mu}) and variance (\code{dn_sigma}; \eqn{\sigma}) of
\eqn{\Delta}N (i.e, trophic enrichment
factor). This prior assumes a normal distribution.
\item The lower (\code{tp_lb}) and upper (\code{tp_ub}) bounds for trophic position.
This prior assumes a uniform distribution.
\item The lower (\code{sigma_lb}) and upper (\code{sigma_ub}) bounds for
variance (\eqn{\sigma}). This prior assumes a uniform distribution.
}
}
\examples{
one_source_priors_params()
}
\seealso{
\code{\link[=one_source_priors]{one_source_priors()}}, \code{\link[=one_source_model]{one_source_model()}}, and \code{\link[brms:brms-package]{brms::brms()}}
}
