% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sspv}
\alias{sspv}
\alias{subsets}
\title{Subsets Pseudo-Vector Constructor}
\usage{
sspv(items)
}
\arguments{
\item{items}{a vector of objects to be subsetted.}
}
\value{
an instance of \code{SSPV}.
}
\description{
The \code{SSPV} class defines a pseudo-vector containing all
the arranged subsets of the objects stored
in \code{items}. The function \code{sspv} is a constructor for this class.
}
\details{
The subsets are arranged according to the order in which the objects
appear in \code{items}. The first subset, containing none of the objects,
is \code{NULL}.
}
\examples{
# create a pseudo-vector of subsets from the first 15 letters
ss <- sspv(letters[1:15])
# generate a description
print(ss)
# compatable with length
length(ss)
# inspect a few of the combinations "stored" in ss
ss[1]
ss[1000]
ss[32768]
}
\author{
Richard Ambler
}
\seealso{
Permutations Pseudo-Vector \code{\link{ppv}}

Combinations Pseudo-Vector \code{\link{cpv}}

Amalgams Pseudo-Vector \code{\link{apv}}

Selections Pseudo-Vector \code{\link{spv}}
}

