% Generated by roxygen2 (4.0.2): do not edit by hand
\name{spv}
\alias{selection}
\alias{selections}
\alias{spv}
\title{Selections Pseudo-Vector Constructor}
\usage{
spv(k, items)
}
\arguments{
\item{k}{the number of objects taken at a time.}

\item{items}{a vector of objects to be selected.}
}
\value{
an instance of \code{SPV}.
}
\description{
The \code{SPV} class defines a pseudo-vector containing all
the arranged \code{k}-selections (combinations with replacement) of the objects stored
in \code{items}. The function \code{spv} is a constructor for this class.
}
\details{
The selections are arranged according to the order in which the objects
appear in \code{items}. The arrangement is very similar to the arrangement
of combinations (see \link{cpv}) except that objects may be repeatedly selected.
}
\examples{
# create a pseudo-vector of 10-selections from the first 15 letters
s <- spv(10, letters[1:15])
# generate a description
print(s)
# compatable with length
length(s)
# inspect a few of the combinations "stored" in s
s[1]
s[1000]
s[1961256]
}
\author{
Richard Ambler
}
\references{
Steinhaus-Johnson-Trotter algorithm. (2014, April 29).
In \emph{Wikipedia, The Free Encyclopedia}.
Retrieved 13:24, September 5, 2014
}
\seealso{
Permutations Pseudo-Vector \code{\link{ppv}}

Combinations Pseudo-Vector \code{\link{cpv}}

Amalgams Pseudo-Vector \code{\link{apv}}

Subsets Pseudo-Vector \code{\link{sspv}}
}

