% Generated by roxygen2 (4.0.2): do not edit by hand
\name{apv}
\alias{amalgam}
\alias{amalgams}
\alias{apv}
\title{Amalgams Pseudo-Vector Constructor}
\usage{
apv(k, items)
}
\arguments{
\item{k}{the number of objects taken at a time.}

\item{items}{a vector of objects to be amalgamated.}
}
\value{
an instance of \code{APV}.
}
\description{
The \code{APV} class defines a pseudo-vector containing all
the arranged \code{k}-amalgams (permutations with replacement) of the objects stored
in \code{items}. The function \code{apv} is a constructor for this class.
}
\details{
The amalgams are arranged according to the order in which the objects
appear in \code{items}. The arrangement is very similar to that used by the \code{PPV} class
(see \link{ppv}) except that objects are replaced during permutation creation.
}
\examples{
# create a pseudo-vector of 10-amalgams from the first 15 letters
a <- apv(10, letters[1:15])
# generate a description
print(a)
# compatable with length
length(a)
# inspect a few of the combinations "stored" in a
a[1]
a[1000000]
a[576650390625]
}
\author{
Richard Ambler
}
\references{
Steinhaus-Johnson-Trotter algorithm. (2014, April 29).
In \emph{Wikipedia, The Free Encyclopedia}.
Retrieved 13:24, September 5, 2014
}
\seealso{
Permutations Pseudo-Vector \code{\link{ppv}}

Combinations Pseudo-Vector \code{\link{cpv}}

Selections Pseudo-Vector \code{\link{spv}}

Subsets Pseudo-Vector \code{\link{sspv}}
}

