% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutators.R
\name{add_consistency}
\alias{add_consistency}
\title{Adding consistency regions for reliability curves}
\usage{
add_consistency(x, level = 0.9, method = "resampling_Bernoulli", ...)
}
\arguments{
\item{x}{An object to which a consistency region should be added.}

\item{level}{A single value for the level of confidence.}

\item{method}{A string that gives the name of method to generate the consistency regions. Currently, only: "resampling_Bernoulli".}

\item{...}{Additional arguments passed to methods.}
}
\value{
The object given to \code{x}, but with information about the consistency regions.
This information can be accessed conveniently by using \code{\link[=regions]{regions()}} on the
reliability curve component.
}
\description{
Consistency regions are created under the assumption that the forecasts are calibrated.
A reliability curve that significantly violates the consistency region indicates
a miscalibrated forecast.
}
\examples{
data(ex_binary, package = "triptych")

tr <- triptych(ex_binary) |>
  dplyr::slice(1, 9)

# Bootstrap resampling is expensive
# (the number of bootstrap samples is small to keep execution times short)

tr <- add_consistency(tr, level = 0.9, method = "resampling_Bernoulli", n_boot = 20)
regions(tr$reliability)

}
\seealso{
\code{\link[=resampling_Bernoulli]{resampling_Bernoulli()}}
}
