// Generated by rstantools.  Do not edit by hand.

/*
    trialr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    trialr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with trialr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_AugBin2T1A_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_AugBin2T1A");
    reader.add_event(104, 102, "end", "model_AugBin2T1A");
    return reader;
}
#include <stan_meta_header.hpp>
class model_AugBin2T1A
  : public stan::model::model_base_crtp<model_AugBin2T1A> {
private:
        int N;
        vector_d z0;
        vector_d z1;
        vector_d z2;
        std::vector<int> d1;
        std::vector<int> d2;
        double alpha_mean;
        double alpha_sd;
        double beta_mean;
        double beta_sd;
        double gamma_mean;
        double gamma_sd;
        double sigma_mean;
        double sigma_sd;
        double omega_lkj_eta;
        double alpha_d1_mean;
        double alpha_d1_sd;
        double gamma_d1_mean;
        double gamma_d1_sd;
        double alpha_d2_mean;
        double alpha_d2_sd;
        double gamma_d2_mean;
        double gamma_d2_sd;
        std::vector<vector_d> y;
public:
    model_AugBin2T1A(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_AugBin2T1A(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_AugBin2T1A_namespace::model_AugBin2T1A";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 5;
            validate_non_negative_index("z0", "N", N);
            context__.validate_dims("data initialization", "z0", "vector_d", context__.to_vec(N));
            z0 = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("z0");
            pos__ = 0;
            size_t z0_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < z0_j_1_max__; ++j_1__) {
                z0(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 6;
            validate_non_negative_index("z1", "N", N);
            context__.validate_dims("data initialization", "z1", "vector_d", context__.to_vec(N));
            z1 = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("z1");
            pos__ = 0;
            size_t z1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < z1_j_1_max__; ++j_1__) {
                z1(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 7;
            validate_non_negative_index("z2", "N", N);
            context__.validate_dims("data initialization", "z2", "vector_d", context__.to_vec(N));
            z2 = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("z2");
            pos__ = 0;
            size_t z2_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < z2_j_1_max__; ++j_1__) {
                z2(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("d1", "N", N);
            context__.validate_dims("data initialization", "d1", "int", context__.to_vec(N));
            d1 = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("d1");
            pos__ = 0;
            size_t d1_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < d1_k_0_max__; ++k_0__) {
                d1[k_0__] = vals_i__[pos__++];
            }
            size_t d1_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < d1_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "d1[i_0__]", d1[i_0__], 0);
                check_less_or_equal(function__, "d1[i_0__]", d1[i_0__], 1);
            }
            current_statement_begin__ = 10;
            validate_non_negative_index("d2", "N", N);
            context__.validate_dims("data initialization", "d2", "int", context__.to_vec(N));
            d2 = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("d2");
            pos__ = 0;
            size_t d2_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < d2_k_0_max__; ++k_0__) {
                d2[k_0__] = vals_i__[pos__++];
            }
            size_t d2_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < d2_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "d2[i_0__]", d2[i_0__], 0);
                check_less_or_equal(function__, "d2[i_0__]", d2[i_0__], 1);
            }
            current_statement_begin__ = 14;
            context__.validate_dims("data initialization", "alpha_mean", "double", context__.to_vec());
            alpha_mean = double(0);
            vals_r__ = context__.vals_r("alpha_mean");
            pos__ = 0;
            alpha_mean = vals_r__[pos__++];
            current_statement_begin__ = 15;
            context__.validate_dims("data initialization", "alpha_sd", "double", context__.to_vec());
            alpha_sd = double(0);
            vals_r__ = context__.vals_r("alpha_sd");
            pos__ = 0;
            alpha_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "alpha_sd", alpha_sd, 0);
            current_statement_begin__ = 16;
            context__.validate_dims("data initialization", "beta_mean", "double", context__.to_vec());
            beta_mean = double(0);
            vals_r__ = context__.vals_r("beta_mean");
            pos__ = 0;
            beta_mean = vals_r__[pos__++];
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "beta_sd", "double", context__.to_vec());
            beta_sd = double(0);
            vals_r__ = context__.vals_r("beta_sd");
            pos__ = 0;
            beta_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "beta_sd", beta_sd, 0);
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "gamma_mean", "double", context__.to_vec());
            gamma_mean = double(0);
            vals_r__ = context__.vals_r("gamma_mean");
            pos__ = 0;
            gamma_mean = vals_r__[pos__++];
            current_statement_begin__ = 19;
            context__.validate_dims("data initialization", "gamma_sd", "double", context__.to_vec());
            gamma_sd = double(0);
            vals_r__ = context__.vals_r("gamma_sd");
            pos__ = 0;
            gamma_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "gamma_sd", gamma_sd, 0);
            current_statement_begin__ = 20;
            context__.validate_dims("data initialization", "sigma_mean", "double", context__.to_vec());
            sigma_mean = double(0);
            vals_r__ = context__.vals_r("sigma_mean");
            pos__ = 0;
            sigma_mean = vals_r__[pos__++];
            current_statement_begin__ = 21;
            context__.validate_dims("data initialization", "sigma_sd", "double", context__.to_vec());
            sigma_sd = double(0);
            vals_r__ = context__.vals_r("sigma_sd");
            pos__ = 0;
            sigma_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_sd", sigma_sd, 0);
            current_statement_begin__ = 23;
            context__.validate_dims("data initialization", "omega_lkj_eta", "double", context__.to_vec());
            omega_lkj_eta = double(0);
            vals_r__ = context__.vals_r("omega_lkj_eta");
            pos__ = 0;
            omega_lkj_eta = vals_r__[pos__++];
            current_statement_begin__ = 25;
            context__.validate_dims("data initialization", "alpha_d1_mean", "double", context__.to_vec());
            alpha_d1_mean = double(0);
            vals_r__ = context__.vals_r("alpha_d1_mean");
            pos__ = 0;
            alpha_d1_mean = vals_r__[pos__++];
            current_statement_begin__ = 26;
            context__.validate_dims("data initialization", "alpha_d1_sd", "double", context__.to_vec());
            alpha_d1_sd = double(0);
            vals_r__ = context__.vals_r("alpha_d1_sd");
            pos__ = 0;
            alpha_d1_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "alpha_d1_sd", alpha_d1_sd, 0);
            current_statement_begin__ = 27;
            context__.validate_dims("data initialization", "gamma_d1_mean", "double", context__.to_vec());
            gamma_d1_mean = double(0);
            vals_r__ = context__.vals_r("gamma_d1_mean");
            pos__ = 0;
            gamma_d1_mean = vals_r__[pos__++];
            current_statement_begin__ = 28;
            context__.validate_dims("data initialization", "gamma_d1_sd", "double", context__.to_vec());
            gamma_d1_sd = double(0);
            vals_r__ = context__.vals_r("gamma_d1_sd");
            pos__ = 0;
            gamma_d1_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "gamma_d1_sd", gamma_d1_sd, 0);
            current_statement_begin__ = 29;
            context__.validate_dims("data initialization", "alpha_d2_mean", "double", context__.to_vec());
            alpha_d2_mean = double(0);
            vals_r__ = context__.vals_r("alpha_d2_mean");
            pos__ = 0;
            alpha_d2_mean = vals_r__[pos__++];
            current_statement_begin__ = 30;
            context__.validate_dims("data initialization", "alpha_d2_sd", "double", context__.to_vec());
            alpha_d2_sd = double(0);
            vals_r__ = context__.vals_r("alpha_d2_sd");
            pos__ = 0;
            alpha_d2_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "alpha_d2_sd", alpha_d2_sd, 0);
            current_statement_begin__ = 31;
            context__.validate_dims("data initialization", "gamma_d2_mean", "double", context__.to_vec());
            gamma_d2_mean = double(0);
            vals_r__ = context__.vals_r("gamma_d2_mean");
            pos__ = 0;
            gamma_d2_mean = vals_r__[pos__++];
            current_statement_begin__ = 32;
            context__.validate_dims("data initialization", "gamma_d2_sd", "double", context__.to_vec());
            gamma_d2_sd = double(0);
            vals_r__ = context__.vals_r("gamma_d2_sd");
            pos__ = 0;
            gamma_d2_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "gamma_d2_sd", gamma_d2_sd, 0);
            // initialize transformed data variables
            current_statement_begin__ = 36;
            validate_non_negative_index("y", "2", 2);
            validate_non_negative_index("y", "N", N);
            y = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(N, Eigen::Matrix<double, Eigen::Dynamic, 1>(2));
            stan::math::fill(y, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 37;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 38;
                stan::model::assign(y, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            stan::math::log((get_base1(z1, i, "z1", 1) / get_base1(z0, i, "z0", 1))), 
                            "assigning variable y");
                current_statement_begin__ = 39;
                stan::model::assign(y, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                            stan::math::log((get_base1(z2, i, "z2", 1) / get_base1(z0, i, "z0", 1))), 
                            "assigning variable y");
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 44;
            num_params_r__ += 1;
            current_statement_begin__ = 45;
            num_params_r__ += 1;
            current_statement_begin__ = 46;
            num_params_r__ += 1;
            current_statement_begin__ = 47;
            validate_non_negative_index("Omega", "2", 2);
            validate_non_negative_index("Omega", "2", 2);
            num_params_r__ += ((2 * (2 - 1)) / 2);
            current_statement_begin__ = 48;
            validate_non_negative_index("sigma", "2", 2);
            num_params_r__ += 2;
            current_statement_begin__ = 49;
            num_params_r__ += 1;
            current_statement_begin__ = 50;
            num_params_r__ += 1;
            current_statement_begin__ = 51;
            num_params_r__ += 1;
            current_statement_begin__ = 52;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_AugBin2T1A() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 44;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "alpha", "double", context__.to_vec());
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(alpha);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 45;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "beta", "double", context__.to_vec());
        double beta(0);
        beta = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 46;
        if (!(context__.contains_r("gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "gamma", "double", context__.to_vec());
        double gamma(0);
        gamma = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(gamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 47;
        if (!(context__.contains_r("Omega")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable Omega missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("Omega");
        pos__ = 0U;
        validate_non_negative_index("Omega", "2", 2);
        validate_non_negative_index("Omega", "2", 2);
        context__.validate_dims("parameter initialization", "Omega", "matrix_d", context__.to_vec(2,2));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Omega(2, 2);
        size_t Omega_j_2_max__ = 2;
        size_t Omega_j_1_max__ = 2;
        for (size_t j_2__ = 0; j_2__ < Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Omega_j_1_max__; ++j_1__) {
                Omega(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.corr_matrix_unconstrain(Omega);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable Omega: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 48;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "2", 2);
        context__.validate_dims("parameter initialization", "sigma", "vector_d", context__.to_vec(2));
        Eigen::Matrix<double, Eigen::Dynamic, 1> sigma(2);
        size_t sigma_j_1_max__ = 2;
        for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
            sigma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 49;
        if (!(context__.contains_r("alphaD1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alphaD1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alphaD1");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "alphaD1", "double", context__.to_vec());
        double alphaD1(0);
        alphaD1 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(alphaD1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alphaD1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 50;
        if (!(context__.contains_r("gammaD1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gammaD1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gammaD1");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "gammaD1", "double", context__.to_vec());
        double gammaD1(0);
        gammaD1 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(gammaD1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gammaD1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 51;
        if (!(context__.contains_r("alphaD2")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alphaD2 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alphaD2");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "alphaD2", "double", context__.to_vec());
        double alphaD2(0);
        alphaD2 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(alphaD2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alphaD2: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 52;
        if (!(context__.contains_r("gammaD2")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gammaD2 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gammaD2");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "gammaD2", "double", context__.to_vec());
        double gammaD2(0);
        gammaD2 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(gammaD2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gammaD2: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 44;
            local_scalar_t__ alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.scalar_constrain(lp__);
            else
                alpha = in__.scalar_constrain();
            current_statement_begin__ = 45;
            local_scalar_t__ beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.scalar_constrain(lp__);
            else
                beta = in__.scalar_constrain();
            current_statement_begin__ = 46;
            local_scalar_t__ gamma;
            (void) gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma = in__.scalar_constrain(lp__);
            else
                gamma = in__.scalar_constrain();
            current_statement_begin__ = 47;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Omega;
            (void) Omega;  // dummy to suppress unused var warning
            if (jacobian__)
                Omega = in__.corr_matrix_constrain(2, lp__);
            else
                Omega = in__.corr_matrix_constrain(2);
            current_statement_begin__ = 48;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.vector_lb_constrain(0, 2, lp__);
            else
                sigma = in__.vector_lb_constrain(0, 2);
            current_statement_begin__ = 49;
            local_scalar_t__ alphaD1;
            (void) alphaD1;  // dummy to suppress unused var warning
            if (jacobian__)
                alphaD1 = in__.scalar_constrain(lp__);
            else
                alphaD1 = in__.scalar_constrain();
            current_statement_begin__ = 50;
            local_scalar_t__ gammaD1;
            (void) gammaD1;  // dummy to suppress unused var warning
            if (jacobian__)
                gammaD1 = in__.scalar_constrain(lp__);
            else
                gammaD1 = in__.scalar_constrain();
            current_statement_begin__ = 51;
            local_scalar_t__ alphaD2;
            (void) alphaD2;  // dummy to suppress unused var warning
            if (jacobian__)
                alphaD2 = in__.scalar_constrain(lp__);
            else
                alphaD2 = in__.scalar_constrain();
            current_statement_begin__ = 52;
            local_scalar_t__ gammaD2;
            (void) gammaD2;  // dummy to suppress unused var warning
            if (jacobian__)
                gammaD2 = in__.scalar_constrain(lp__);
            else
                gammaD2 = in__.scalar_constrain();
            // transformed parameters
            current_statement_begin__ = 56;
            validate_non_negative_index("Mu", "2", 2);
            validate_non_negative_index("Mu", "N", N);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > Mu(N, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(2));
            stan::math::initialize(Mu, DUMMY_VAR__);
            stan::math::fill(Mu, DUMMY_VAR__);
            current_statement_begin__ = 57;
            validate_non_negative_index("Sigma", "2", 2);
            validate_non_negative_index("Sigma", "2", 2);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Sigma(2, 2);
            stan::math::initialize(Sigma, DUMMY_VAR__);
            stan::math::fill(Sigma, DUMMY_VAR__);
            current_statement_begin__ = 58;
            validate_non_negative_index("ProbD", "2", 2);
            validate_non_negative_index("ProbD", "N", N);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > ProbD(N, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(2));
            stan::math::initialize(ProbD, DUMMY_VAR__);
            stan::math::fill(ProbD, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 60;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 61;
                stan::model::assign(Mu, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            (alpha + (gamma * get_base1(z0, i, "z0", 1))), 
                            "assigning variable Mu");
                current_statement_begin__ = 62;
                stan::model::assign(Mu, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                            (beta + (gamma * get_base1(z0, i, "z0", 1))), 
                            "assigning variable Mu");
                current_statement_begin__ = 63;
                stan::model::assign(ProbD, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            inv_logit((alphaD1 + (gammaD1 * get_base1(z0, i, "z0", 1)))), 
                            "assigning variable ProbD");
                current_statement_begin__ = 64;
                stan::model::assign(ProbD, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                            inv_logit((alphaD2 + (gammaD2 * get_base1(z1, i, "z1", 1)))), 
                            "assigning variable ProbD");
            }
            current_statement_begin__ = 67;
            stan::math::assign(Sigma, quad_form_diag(Omega, sigma));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 56;
            size_t Mu_k_0_max__ = N;
            size_t Mu_j_1_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < Mu_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < Mu_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(Mu[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: Mu" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable Mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 57;
            size_t Sigma_j_1_max__ = 2;
            size_t Sigma_j_2_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(Sigma(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: Sigma" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable Sigma: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            stan::math::check_cov_matrix(function__, "Sigma", Sigma);
            current_statement_begin__ = 58;
            size_t ProbD_k_0_max__ = N;
            size_t ProbD_j_1_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < ProbD_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < ProbD_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(ProbD[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: ProbD" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ProbD: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            // model body
            {
            current_statement_begin__ = 72;
            validate_non_negative_index("d", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> d(N);
            stan::math::initialize(d, DUMMY_VAR__);
            stan::math::fill(d, DUMMY_VAR__);
            current_statement_begin__ = 75;
            lp_accum__.add(normal_log<propto__>(alpha, alpha_mean, alpha_sd));
            current_statement_begin__ = 76;
            lp_accum__.add(normal_log<propto__>(beta, beta_mean, beta_sd));
            current_statement_begin__ = 77;
            lp_accum__.add(normal_log<propto__>(gamma, gamma_mean, gamma_sd));
            current_statement_begin__ = 81;
            lp_accum__.add(normal_log<propto__>(sigma, sigma_mean, sigma_sd));
            current_statement_begin__ = 84;
            lp_accum__.add(lkj_corr_log<propto__>(Omega, omega_lkj_eta));
            current_statement_begin__ = 87;
            lp_accum__.add(normal_log<propto__>(alphaD1, alpha_d1_mean, alpha_d1_sd));
            current_statement_begin__ = 88;
            lp_accum__.add(normal_log<propto__>(gammaD1, gamma_d1_mean, gamma_d1_sd));
            current_statement_begin__ = 89;
            lp_accum__.add(normal_log<propto__>(alphaD2, alpha_d2_mean, alpha_d2_sd));
            current_statement_begin__ = 90;
            lp_accum__.add(normal_log<propto__>(gammaD2, gamma_d2_mean, gamma_d2_sd));
            current_statement_begin__ = 93;
            lp_accum__.add(multi_normal_log<propto__>(y, Mu, Sigma));
            current_statement_begin__ = 96;
            stan::math::assign(d, rep_vector(0, N));
            current_statement_begin__ = 97;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 98;
                lp_accum__.add(bernoulli_log<propto__>(get_base1(d1, i, "d1", 1), get_base1(get_base1(ProbD, i, "ProbD", 1), 1, "ProbD", 2)));
                current_statement_begin__ = 99;
                if (as_bool(logical_eq(get_base1(d1, i, "d1", 1), 1))) {
                    current_statement_begin__ = 99;
                    stan::model::assign(d, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                1, 
                                "assigning variable d");
                }
                current_statement_begin__ = 100;
                if (as_bool(logical_eq(get_base1(d, i, "d", 1), 0))) {
                    current_statement_begin__ = 100;
                    lp_accum__.add(bernoulli_log<propto__>(get_base1(d2, i, "d2", 1), get_base1(get_base1(ProbD, i, "ProbD", 1), 2, "ProbD", 2)));
                }
            }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha");
        names__.push_back("beta");
        names__.push_back("gamma");
        names__.push_back("Omega");
        names__.push_back("sigma");
        names__.push_back("alphaD1");
        names__.push_back("gammaD1");
        names__.push_back("alphaD2");
        names__.push_back("gammaD2");
        names__.push_back("Mu");
        names__.push_back("Sigma");
        names__.push_back("ProbD");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(2);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_AugBin2T1A_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double alpha = in__.scalar_constrain();
        vars__.push_back(alpha);
        double beta = in__.scalar_constrain();
        vars__.push_back(beta);
        double gamma = in__.scalar_constrain();
        vars__.push_back(gamma);
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Omega = in__.corr_matrix_constrain(2);
        size_t Omega_j_2_max__ = 2;
        size_t Omega_j_1_max__ = 2;
        for (size_t j_2__ = 0; j_2__ < Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Omega_j_1_max__; ++j_1__) {
                vars__.push_back(Omega(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> sigma = in__.vector_lb_constrain(0, 2);
        size_t sigma_j_1_max__ = 2;
        for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
            vars__.push_back(sigma(j_1__));
        }
        double alphaD1 = in__.scalar_constrain();
        vars__.push_back(alphaD1);
        double gammaD1 = in__.scalar_constrain();
        vars__.push_back(gammaD1);
        double alphaD2 = in__.scalar_constrain();
        vars__.push_back(alphaD2);
        double gammaD2 = in__.scalar_constrain();
        vars__.push_back(gammaD2);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 56;
            validate_non_negative_index("Mu", "2", 2);
            validate_non_negative_index("Mu", "N", N);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > Mu(N, Eigen::Matrix<double, Eigen::Dynamic, 1>(2));
            stan::math::initialize(Mu, DUMMY_VAR__);
            stan::math::fill(Mu, DUMMY_VAR__);
            current_statement_begin__ = 57;
            validate_non_negative_index("Sigma", "2", 2);
            validate_non_negative_index("Sigma", "2", 2);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Sigma(2, 2);
            stan::math::initialize(Sigma, DUMMY_VAR__);
            stan::math::fill(Sigma, DUMMY_VAR__);
            current_statement_begin__ = 58;
            validate_non_negative_index("ProbD", "2", 2);
            validate_non_negative_index("ProbD", "N", N);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > ProbD(N, Eigen::Matrix<double, Eigen::Dynamic, 1>(2));
            stan::math::initialize(ProbD, DUMMY_VAR__);
            stan::math::fill(ProbD, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 60;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 61;
                stan::model::assign(Mu, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            (alpha + (gamma * get_base1(z0, i, "z0", 1))), 
                            "assigning variable Mu");
                current_statement_begin__ = 62;
                stan::model::assign(Mu, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                            (beta + (gamma * get_base1(z0, i, "z0", 1))), 
                            "assigning variable Mu");
                current_statement_begin__ = 63;
                stan::model::assign(ProbD, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            inv_logit((alphaD1 + (gammaD1 * get_base1(z0, i, "z0", 1)))), 
                            "assigning variable ProbD");
                current_statement_begin__ = 64;
                stan::model::assign(ProbD, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                            inv_logit((alphaD2 + (gammaD2 * get_base1(z1, i, "z1", 1)))), 
                            "assigning variable ProbD");
            }
            current_statement_begin__ = 67;
            stan::math::assign(Sigma, quad_form_diag(Omega, sigma));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 57;
            stan::math::check_cov_matrix(function__, "Sigma", Sigma);
            // write transformed parameters
            if (include_tparams__) {
                size_t Mu_j_1_max__ = 2;
                size_t Mu_k_0_max__ = N;
                for (size_t j_1__ = 0; j_1__ < Mu_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < Mu_k_0_max__; ++k_0__) {
                        vars__.push_back(Mu[k_0__](j_1__));
                    }
                }
                size_t Sigma_j_2_max__ = 2;
                size_t Sigma_j_1_max__ = 2;
                for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                        vars__.push_back(Sigma(j_1__, j_2__));
                    }
                }
                size_t ProbD_j_1_max__ = 2;
                size_t ProbD_k_0_max__ = N;
                for (size_t j_1__ = 0; j_1__ < ProbD_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < ProbD_k_0_max__; ++k_0__) {
                        vars__.push_back(ProbD[k_0__](j_1__));
                    }
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_AugBin2T1A";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gamma";
        param_names__.push_back(param_name_stream__.str());
        size_t Omega_j_2_max__ = 2;
        size_t Omega_j_1_max__ = 2;
        for (size_t j_2__ = 0; j_2__ < Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Omega_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Omega" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t sigma_j_1_max__ = 2;
        for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "alphaD1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gammaD1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alphaD2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gammaD2";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t Mu_j_1_max__ = 2;
            size_t Mu_k_0_max__ = N;
            for (size_t j_1__ = 0; j_1__ < Mu_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < Mu_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Mu" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t Sigma_j_2_max__ = 2;
            size_t Sigma_j_1_max__ = 2;
            for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Sigma" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t ProbD_j_1_max__ = 2;
            size_t ProbD_k_0_max__ = N;
            for (size_t j_1__ = 0; j_1__ < ProbD_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < ProbD_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "ProbD" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gamma";
        param_names__.push_back(param_name_stream__.str());
        size_t Omega_j_1_max__ = ((2 * (2 - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < Omega_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Omega" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_j_1_max__ = 2;
        for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "alphaD1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gammaD1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alphaD2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gammaD2";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t Mu_j_1_max__ = 2;
            size_t Mu_k_0_max__ = N;
            for (size_t j_1__ = 0; j_1__ < Mu_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < Mu_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Mu" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t Sigma_j_1_max__ = (2 + ((2 * (2 - 1)) / 2));
            for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Sigma" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ProbD_j_1_max__ = 2;
            size_t ProbD_k_0_max__ = N;
            for (size_t j_1__ = 0; j_1__ < ProbD_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < ProbD_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "ProbD" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_AugBin2T1A_namespace::model_AugBin2T1A stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
