% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efftox_priors.R
\name{efftox_priors}
\alias{efftox_priors}
\title{Simple class to hold prior hyperparameters for the EffTox model.}
\usage{
efftox_priors(
  alpha_mean,
  alpha_sd,
  beta_mean,
  beta_sd,
  gamma_mean,
  gamma_sd,
  zeta_mean,
  zeta_sd,
  eta_mean,
  eta_sd,
  psi_mean,
  psi_sd
)
}
\arguments{
\item{alpha_mean}{The prior normal mean of the intercept term in the toxicity
logit model. A number.}

\item{alpha_sd}{The prior normal standard deviation of the intercept term in
the toxicity logit model. A number.}

\item{beta_mean}{The prior normal mean of the slope term in the toxicity
logit model. A number.}

\item{beta_sd}{The prior normal standard deviation of the slope term in the
toxicity logit model. A number.}

\item{gamma_mean}{The prior normal mean of the intercept term in the efficacy
logit model. A number.}

\item{gamma_sd}{The prior normal standard deviation of the intercept term in
the efficacy logit model. A number.}

\item{zeta_mean}{The prior normal mean of the slope term in the efficacy logit
model. A number.}

\item{zeta_sd}{The prior normal standard deviation of the slope term in the
efficacy logit model. A number.}

\item{eta_mean}{The prior normal mean of the squared term coefficient in the
efficacy logit model. A number.}

\item{eta_sd}{The prior normal standard deviation of the squared term
coefficient in the efficacy logit model. A number.}

\item{psi_mean}{The prior normal mean of the association term in the combined
efficacy-toxicity model. A number.}

\item{psi_sd}{The prior normal standard deviation of the association term in
the combined efficacy-toxicity model. A number.}
}
\value{
list-like, instance of class \code{efftox_priors}.
}
\description{
Simple class to hold prior hyperparameters for the EffTox model.
}
\examples{
# The priors used in Thall et al. (2014)
p <- efftox_priors(alpha_mean = -7.9593, alpha_sd = 3.5487,
                   beta_mean = 1.5482, beta_sd = 3.5018,
                   gamma_mean = 0.7367, gamma_sd = 2.5423,
                   zeta_mean = 3.4181, zeta_sd = 2.4406,
                   eta_mean = 0, eta_sd = 0.2,
                   psi_mean = 0, psi_sd = 1)
# The class exists simply to hold these twelve values.
}
\references{
Thall, P., & Cook, J. (2004). Dose-Finding Based on Efficacy-Toxicity
    Trade-Offs. Biometrics, 60(3), 684-693.

  Thall, P., Herrick, R., Nguyen, H., Venier, J., & Norris, J. (2014).
    Effective sample size for computing prior hyperparameters in Bayesian
    phase I-II dose-finding. Clinical Trials, 11(6), 657-666.
    https://doi.org/10.1177/1740774514547397
}
\author{
Kristian Brock \email{kristian.brock@gmail.com}
}
