% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_aic.R
\name{calculate_aic}
\alias{calculate_aic}
\alias{calculate_aic.default}
\alias{calculate_aic.trending_model}
\alias{calculate_aic.list}
\alias{calculate_aic.trending_fit}
\alias{calculate_aic.trending_fit_tbl}
\title{Generic for calculating the AIC}
\usage{
calculate_aic(x, ...)

\method{calculate_aic}{default}(x, ...)

\method{calculate_aic}{trending_model}(x, data, as_tibble = FALSE, ...)

\method{calculate_aic}{list}(x, data, ...)

\method{calculate_aic}{trending_fit}(x, as_tibble = FALSE, ...)

\method{calculate_aic}{trending_fit_tbl}(x, ...)
}
\arguments{
\item{x}{An \R object.}

\item{...}{Not currently used.}

\item{data}{a \code{data.frame} containing data (including the response variable
and all predictors) used in the specified model.}

\item{as_tibble}{Should the result be returned as \link[tibble:tibble]{tibble}
(\code{as_tibble = TRUE}) or a list (\code{as_tibble = FALSE}).}
}
\value{
For a single \code{\link[trending:fit]{trending_fit}} input, if
\code{as_tibble = FALSE} the object returned will be a list with entries:
\itemize{
\item metric: "AIC"
\item result: the resulting AIC value fit (NULL if the calculation failed)
\item warnings: any warnings generated during calculation
\item errors: any errors generated during calculation
}

If \code{as_tibble = TRUE}, or the input is a
\code{\link[trending:fit.trending_model]{trending_fit_tbl}}, then the output
will be a \link[tibble:tibble]{tibble} with one row for each fitted model
columns corresponding to output generated with single model input.
}
\description{
Generic \code{calculate_aic()} returns the Akaike's 'An Information Criterion' for
the given input.
}
\details{
Specific methods are given for
\code{\link[trending:fit.trending_model]{trending_fit}} and
\code{\link[trending:fit.trending_model]{trending_fit_tbl}} objects. The default
method applies \code{\link[stats:AIC]{stats::AIC()}} directly.
}
\author{
Tim Taylor

#' @examples
x = rnorm(100, mean = 0)
y = rpois(n = 100, lambda = exp(1.5 + 0.5*x))
dat <- data.frame(x = x, y = y)
poisson_model <- glm_model(y ~ x , family = "poisson")
negbin_model <- glm_nb_model(y ~ x)
fitted_model <- fit(poisson_model, dat)
fitted_models <- fit(list(poisson_model, negbin_model), data = dat)

calculate_aic(poisson_model, dat)
calculate_aic(fitted_model)
calculate_aic(fitted_model, as_tibble = TRUE)
calculate_aic(fitted_models)
}
